/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.cindy.Message;
import net.sf.cindy.impl.AbstractSession;
import net.sf.cindy.impl.Constants;
import net.sf.cindy.util.ElapsedTime;
import net.sf.cindy.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractSimulatedSession
extends AbstractSession {
    private static final Log log = LogFactory.getLog((Class)AbstractSimulatedSession.class);
    private final Set writeLocks = Collections.synchronizedSet(new HashSet());
    private volatile boolean closing;
    private SimulateThread thread;
    private int idleTime;
    private static int i;

    public boolean isClosing() {
        return this.closing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl) {
        if (!this.isAvailable()) {
            return;
        }
        AbstractSimulatedSession abstractSimulatedSession = this;
        synchronized (abstractSimulatedSession) {
            this.closing = true;
            Set set = this.writeLocks;
            synchronized (set) {
                Iterator iterator = this.writeLocks.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    iterator.remove();
                    Object e2 = e;
                    synchronized (e2) {
                        e.notify();
                    }
                }
            }
            this.idleTime = 0;
            this.doClose();
            if (Thread.currentThread() != this.thread && this.thread != null) {
                while (this.thread.isAlive()) {
                    try {
                        this.thread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.thread = null;
            this.closing = false;
            this.dispatchSessionClosed();
        }
    }

    protected abstract void doClose();

    public synchronized void start(boolean bl) throws IllegalStateException {
        if (this.isStarted()) {
            return;
        }
        try {
            this.doStart();
        }
        catch (IOException iOException) {
            this.dispatchException(iOException);
            this.doClose();
            this.dispatchSessionClosed();
            return;
        }
        this.idleTime = 0;
        this.dispatchSessionEstablished();
        this.thread = new SimulateThread();
        this.thread.start();
    }

    protected abstract void doStart() throws IOException;

    public void onEvent(Object object, Object object2) {
        if (object == Constants.EV_UNREGISTER) {
            this.close();
        }
        super.onEvent(object, object2);
    }

    protected void checkWriteToWriteQueue(Message message) throws IllegalArgumentException, IllegalStateException {
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        if (!this.isAvailable()) {
            throw new IllegalStateException("session is not available");
        }
    }

    public void write(Message message) throws IllegalArgumentException, IllegalStateException {
        this.checkWriteToWriteQueue(message);
        if (log.isTraceEnabled()) {
            log.trace((Object)("session " + this.getId() + " write message " + message));
        }
        this.writeQueue.push(new Object[]{message, null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean blockWrite(Message message) throws IllegalArgumentException, IllegalStateException {
        AbstractSession.WriteLock writeLock;
        this.checkWriteToWriteQueue(message);
        if (log.isTraceEnabled()) {
            log.trace((Object)("session " + this.getId() + " block write message " + message));
        }
        AbstractSession.WriteLock writeLock2 = writeLock = new AbstractSession.WriteLock();
        synchronized (writeLock2) {
            block12: {
                this.writeQueue.push(new Object[]{message, writeLock});
                if (Thread.currentThread() != this.thread) {
                    this.writeLocks.add(writeLock);
                    AbstractSession.WriteLock writeLock3 = writeLock;
                    synchronized (writeLock3) {
                        try {
                            writeLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.writeLocks.remove(writeLock);
                    return writeLock.isSuccess();
                }
                try {
                    this.sendLoop(message);
                }
                catch (IOException iOException) {
                    if (!this.isStarted()) break block12;
                    this.dispatchException(iOException);
                    this.close();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLoop(Message message) throws IOException {
        Object[] objectArray;
        while (this.isStarted() && (objectArray = (Object[])this.writeQueue.pop()) != null) {
            Message message2 = (Message)objectArray[0];
            AbstractSession.WriteLock writeLock = (AbstractSession.WriteLock)objectArray[1];
            this.send(message2);
            this.dispatchMessageSent(message2);
            this.idleTime = 0;
            if (writeLock != null) {
                writeLock.setSuccess(true);
                AbstractSession.WriteLock writeLock2 = writeLock;
                synchronized (writeLock2) {
                    writeLock.notify();
                }
            }
            if (message2 != message) continue;
            return;
        }
    }

    protected abstract void send(Message var1) throws IOException;

    protected abstract Message receive() throws IOException;

    private class SimulateThread
    extends Thread {
        public SimulateThread() {
            super(Utils.getClassSimpleName(AbstractSimulatedSession.this.getClass()) + "-" + i++);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (AbstractSimulatedSession.this.isStarted()) {
                    ElapsedTime elapsedTime = new ElapsedTime();
                    try {
                        Message message = AbstractSimulatedSession.this.receive();
                        if (message != null) {
                            AbstractSimulatedSession.this.dispatchMessageReceived(message);
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        AbstractSimulatedSession.this.idleTime = (int)((long)AbstractSimulatedSession.this.idleTime + elapsedTime.getElapsedTime());
                    }
                    AbstractSimulatedSession.this.sendLoop(null);
                    if (AbstractSimulatedSession.this.idleTime < AbstractSimulatedSession.this.getSessionTimeout()) continue;
                    AbstractSimulatedSession.this.dispatchSessionTimeout();
                    AbstractSimulatedSession.this.idleTime = 0;
                }
            }
            catch (IOException iOException) {
                if (AbstractSimulatedSession.this.isStarted()) {
                    AbstractSimulatedSession.this.dispatchException(iOException);
                }
            }
            finally {
                AbstractSimulatedSession.this.close();
            }
        }
    }
}

