/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.bos;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.ratelim.RateMonitor;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snaccmd.conn.ClientReadyCmd;
import net.kano.joscar.snaccmd.conn.ClientVersionsCmd;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.snaccmd.conn.RateAck;
import net.kano.joscar.snaccmd.conn.RateClassInfo;
import net.kano.joscar.snaccmd.conn.RateInfoCmd;
import net.kano.joscar.snaccmd.conn.RateInfoRequest;
import net.kano.joscar.snaccmd.conn.ServerReadyCmd;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.oscar.OscarConnListener;
import net.kano.joustsim.oscar.oscar.OscarConnStateEvent;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.AbstractService;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.bos.BosService;
import net.kano.joustsim.oscar.oscar.service.bos.ServerReadyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBosService
extends AbstractService
implements BosService {
    private static final Logger logger = Logger.getLogger(AbstractBosService.class.getName());
    private List<SnacFamilyInfo> snacFamilyInfos = null;
    private RateMonitor rateMonitor;

    protected AbstractBosService(AimConnection aimConnection, OscarConnection oscarConnection) {
        super(aimConnection, oscarConnection, 1);
        OscarConnection oc = this.getOscarConnection();
        this.rateMonitor = new RateMonitor(oc.getSnacProcessor());
        oc.addOscarListener(new OscarConnListener(){

            public void registeredSnacFamilies(OscarConnection conn) {
            }

            public void connStateChanged(OscarConnection conn, OscarConnStateEvent event) {
            }

            public void allFamiliesReady(OscarConnection conn) {
                AbstractBosService.this.allReady();
            }
        });
    }

    @Override
    public SnacFamilyInfo getSnacFamilyInfo() {
        return ConnCommand.FAMILY_INFO;
    }

    private void allReady() {
        logger.fine("All families are ready, sending client ready");
        this.sendSnac((SnacCommand)new ClientReadyCmd(this.getSnacFamilyInfos()));
    }

    @Override
    public void handleSnacPacket(SnacPacketEvent snacPacketEvent) {
        SnacCommand snac = snacPacketEvent.getSnacCommand();
        if (snac instanceof ServerReadyCmd) {
            logger.fine("Server is ready");
            List<Service> services = this.getOscarConnection().getServices();
            ArrayList<SnacFamilyInfo> familyInfos = new ArrayList<SnacFamilyInfo>(services.size());
            for (Service service : services) {
                familyInfos.add(service.getSnacFamilyInfo());
            }
            this.setSnacFamilyInfos(familyInfos);
            this.sendSnac((SnacCommand)new ClientVersionsCmd(familyInfos));
            this.sendSnac((SnacCommand)new RateInfoRequest());
            this.getOscarConnection().postServiceEvent(new ServerReadyEvent(this));
            this.serverReady();
        } else if (snac instanceof RateInfoCmd) {
            RateInfoCmd ric = (RateInfoCmd)snac;
            List rateClasses = ric.getRateClassInfos();
            int[] classes = new int[rateClasses.size()];
            for (int i = 0; i < rateClasses.size(); ++i) {
                classes[i] = ((RateClassInfo)rateClasses.get(i)).getRateClass();
            }
            this.sendSnac((SnacCommand)new RateAck(classes));
            this.trySetReady();
        }
    }

    protected void trySetReady() {
        this.reallySetReady();
    }

    protected void reallySetReady() {
        this.beforeClientReady();
        this.setReady();
    }

    protected void beforeClientReady() {
    }

    protected void serverReady() {
    }

    private synchronized void setSnacFamilyInfos(List<SnacFamilyInfo> snacFamilyInfos) {
        this.snacFamilyInfos = snacFamilyInfos;
    }

    private synchronized List<SnacFamilyInfo> getSnacFamilyInfos() {
        return this.snacFamilyInfos;
    }

    @Override
    public RateMonitor getRateMonitor() {
        return this.rateMonitor;
    }
}

