/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flapcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.flap.FlapCommand;
import net.kano.joscar.flap.FlapPacket;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class LoginFlapCmd
extends FlapCommand {
    public static final int CHANNEL_LOGIN = 1;
    public static final long VERSION_DEFAULT = 1L;
    private static final int TYPE_COOKIE = 6;
    private final long version;
    private final ByteBlock cookie;

    public LoginFlapCmd(FlapPacket packet) {
        super(1);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock flapData = packet.getData();
        this.version = BinaryTools.getUInt((ByteBlock)flapData, (int)0);
        ByteBlock tlvData = flapData.subBlock(4);
        ImmutableTlvChain chain = TlvTools.readChain(tlvData);
        Tlv cookieTlv = chain.getLastTlv(6);
        this.cookie = cookieTlv != null ? cookieTlv.getData() : null;
    }

    public LoginFlapCmd() {
        this(1L, null);
    }

    public LoginFlapCmd(long version) {
        this(version, null);
    }

    public LoginFlapCmd(ByteBlock cookie) {
        this(1L, cookie);
    }

    public LoginFlapCmd(long version, ByteBlock cookie) {
        super(1);
        DefensiveTools.checkRange((long)version, (String)"version", (long)0L);
        this.version = version;
        this.cookie = cookie;
    }

    public final long getVersion() {
        return this.version;
    }

    public final ByteBlock getCookie() {
        return this.cookie;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUInt((OutputStream)out, (long)this.version);
        if (this.cookie != null) {
            new Tlv(6, (Writable)this.cookie).write(out);
        }
    }

    public String toString() {
        return "LoginFlapCmd: version=" + this.version + ", cookie=" + this.cookie;
    }
}

