/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERNull;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERTags;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DERVisibleString;

public class ASN1InputStream
extends FilterInputStream
implements DERTags {
    private DERObject END_OF_STREAM = new DERObject(){

        void encode(DEROutputStream dEROutputStream) throws IOException {
            throw new IOException("Eeek!");
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return object == this;
        }
    };
    boolean eofFound = false;

    public ASN1InputStream(InputStream inputStream) {
        super(inputStream);
    }

    public ASN1InputStream(byte[] byArray) {
        super(new ByteArrayInputStream(byArray));
    }

    protected int readLength() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (n == 128) {
            return -1;
        }
        if (n > 127) {
            int n2 = n & 0x7F;
            if (n2 > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            n = 0;
            for (int i = 0; i < n2; ++i) {
                int n3 = this.read();
                if (n3 < 0) {
                    throw new IOException("EOF found reading length");
                }
                n = (n << 8) + n3;
            }
            if (n < 0) {
                throw new IOException("corrupted steam - negative length found");
            }
        }
        return n;
    }

    protected void readFully(byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        if (n2 == 0) {
            return;
        }
        while ((n = this.read(byArray, byArray.length - n2, n2)) > 0) {
            if ((n2 -= n) != 0) continue;
            return;
        }
        if (n2 != 0) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    protected DERObject buildObject(int n, byte[] byArray) throws IOException {
        if ((n & 0x40) != 0) {
            return new DERApplicationSpecific(n, byArray);
        }
        switch (n) {
            case 5: {
                return new DERNull();
            }
            case 48: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                DERObject dERObject = aSN1InputStream.readObject();
                while (dERObject != null) {
                    aSN1EncodableVector.add(dERObject);
                    dERObject = aSN1InputStream.readObject();
                }
                return new DERSequence(aSN1EncodableVector);
            }
            case 49: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                DERObject dERObject = aSN1InputStream.readObject();
                while (dERObject != null) {
                    aSN1EncodableVector.add(dERObject);
                    dERObject = aSN1InputStream.readObject();
                }
                return new DERSet(aSN1EncodableVector, false);
            }
            case 1: {
                return new DERBoolean(byArray);
            }
            case 2: {
                return new DERInteger(byArray);
            }
            case 10: {
                return new DEREnumerated(byArray);
            }
            case 6: {
                return new DERObjectIdentifier(byArray);
            }
            case 3: {
                byte by = byArray[0];
                byte[] byArray2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
                return new DERBitString(byArray2, (int)by);
            }
            case 18: {
                return new DERNumericString(byArray);
            }
            case 12: {
                return new DERUTF8String(byArray);
            }
            case 19: {
                return new DERPrintableString(byArray);
            }
            case 22: {
                return new DERIA5String(byArray);
            }
            case 20: {
                return new DERT61String(byArray);
            }
            case 26: {
                return new DERVisibleString(byArray);
            }
            case 27: {
                return new DERGeneralString(byArray);
            }
            case 28: {
                return new DERUniversalString(byArray);
            }
            case 30: {
                return new DERBMPString(byArray);
            }
            case 4: {
                return new DEROctetString(byArray);
            }
            case 23: {
                return new DERUTCTime(byArray);
            }
            case 24: {
                return new DERGeneralizedTime(byArray);
            }
        }
        if ((n & 0x80) != 0) {
            int n2 = n & 0x1F;
            if (n2 == 31) {
                int n3 = 0;
                n2 = 0;
                while ((byArray[n3] & 0x80) != 0) {
                    n2 |= byArray[n3++] & 0x7F;
                    n2 <<= 7;
                }
                n2 |= byArray[n3] & 0x7F;
                byte[] byArray3 = byArray;
                byArray = new byte[byArray3.length - (n3 + 1)];
                System.arraycopy(byArray3, n3 + 1, byArray, 0, byArray.length);
            }
            if (byArray.length == 0) {
                if ((n & 0x20) == 0) {
                    return new DERTaggedObject(false, n2, new DERNull());
                }
                return new DERTaggedObject(false, n2, new DERSequence());
            }
            if ((n & 0x20) == 0) {
                return new DERTaggedObject(false, n2, new DEROctetString(byArray));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            DERObject dERObject = aSN1InputStream.readObject();
            if (aSN1InputStream.available() == 0) {
                return new DERTaggedObject(n2, dERObject);
            }
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            while (dERObject != null) {
                aSN1EncodableVector.add(dERObject);
                dERObject = aSN1InputStream.readObject();
            }
            return new DERTaggedObject(false, n2, new DERSequence(aSN1EncodableVector));
        }
        return new DERUnknownTag(n, byArray);
    }

    private byte[] readIndefiniteLengthFully() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = this.read();
        while ((n = this.read()) >= 0 && (n2 != 0 || n != 0)) {
            byteArrayOutputStream.write(n2);
            n2 = n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private BERConstructedOctetString buildConstructedOctetString() throws IOException {
        DERObject dERObject;
        Vector<DERObject> vector = new Vector<DERObject>();
        while ((dERObject = this.readObject()) != this.END_OF_STREAM) {
            vector.addElement(dERObject);
        }
        return new BERConstructedOctetString(vector);
    }

    public DERObject readObject() throws IOException {
        int n = this.read();
        if (n == -1) {
            if (this.eofFound) {
                throw new EOFException("attempt to read past end of file.");
            }
            this.eofFound = true;
            return null;
        }
        int n2 = this.readLength();
        if (n2 < 0) {
            switch (n) {
                case 5: {
                    return new BERNull();
                }
                case 48: {
                    DERObject dERObject;
                    ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                    while ((dERObject = this.readObject()) != this.END_OF_STREAM) {
                        aSN1EncodableVector.add(dERObject);
                    }
                    return new BERSequence(aSN1EncodableVector);
                }
                case 49: {
                    DERObject dERObject;
                    ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                    while ((dERObject = this.readObject()) != this.END_OF_STREAM) {
                        aSN1EncodableVector.add(dERObject);
                    }
                    return new BERSet(aSN1EncodableVector, false);
                }
                case 36: {
                    return this.buildConstructedOctetString();
                }
            }
            if ((n & 0x80) != 0) {
                int n3 = n & 0x1F;
                if (n3 == 31) {
                    int n4 = this.read();
                    n3 = 0;
                    while (n4 >= 0 && (n4 & 0x80) != 0) {
                        n3 |= n4 & 0x7F;
                        n3 <<= 7;
                        n4 = this.read();
                    }
                    n3 |= n4 & 0x7F;
                }
                if ((n & 0x20) == 0) {
                    byte[] byArray = this.readIndefiniteLengthFully();
                    return new BERTaggedObject(false, n3, new DEROctetString(byArray));
                }
                DERObject dERObject = this.readObject();
                if (dERObject == this.END_OF_STREAM) {
                    return new DERTaggedObject(n3);
                }
                DERObject dERObject2 = this.readObject();
                if (dERObject2 == this.END_OF_STREAM) {
                    return new BERTaggedObject(n3, dERObject);
                }
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                aSN1EncodableVector.add(dERObject);
                do {
                    aSN1EncodableVector.add(dERObject2);
                } while ((dERObject2 = this.readObject()) != this.END_OF_STREAM);
                return new BERTaggedObject(false, n3, new BERSequence(aSN1EncodableVector));
            }
            throw new IOException("unknown BER object encountered");
        }
        if (n == 0 && n2 == 0) {
            return this.END_OF_STREAM;
        }
        byte[] byArray = new byte[n2];
        this.readFully(byArray);
        return this.buildObject(n, byArray);
    }
}

