/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.ConfigUtils;
import org.jitsi.videobridge.rest.HandlerImpl;
import org.jitsi.videobridge.rest.MuxServerConnector;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class RESTBundleActivator
implements BundleActivator {
    private static final String ENABLE_REST_SHUTDOWN_PNAME = "org.jitsi.videobridge.ENABLE_REST_SHUTDOWN";
    private static final String JETTY_HOST_PNAME = "org.jitsi.videobridge.rest.jetty.host";
    private static final String JETTY_PORT_PNAME = "org.jitsi.videobridge.rest.jetty.port";
    private static final String JETTY_SSLCONTEXTFACTORY_KEYSTOREPASSWORD = "org.jitsi.videobridge.rest.jetty.sslContextFactory.keyStorePassword";
    private static final String JETTY_SSLCONTEXTFACTORY_KEYSTOREPATH = "org.jitsi.videobridge.rest.jetty.sslContextFactory.keyStorePath";
    private static final String JETTY_SSLCONTEXTFACTORY_NEEDCLIENTAUTH = "org.jitsi.videobridge.rest.jetty.sslContextFactory.needClientAuth";
    private static final String JETTY_TLS_PORT_PNAME = "org.jitsi.videobridge.rest.jetty.tls.port";
    private static final Logger logger = Logger.getLogger(RESTBundleActivator.class);
    private Server server;

    public void start(BundleContext bundleContext) throws Exception {
        boolean start;
        String sslContextFactoryKeyStorePath;
        String sslContextFactoryKeyStorePassword;
        boolean enableRestShutdown;
        ConfigurationService cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        String host = null;
        int port = 8080;
        int tlsPort = 8443;
        boolean sslContextFactoryNeedClientAuth = false;
        if (cfg == null) {
            enableRestShutdown = Boolean.getBoolean(ENABLE_REST_SHUTDOWN_PNAME);
            host = System.getProperty(JETTY_HOST_PNAME, host);
            port = Integer.getInteger(JETTY_PORT_PNAME, port);
            sslContextFactoryKeyStorePassword = System.getProperty(JETTY_SSLCONTEXTFACTORY_KEYSTOREPASSWORD);
            sslContextFactoryKeyStorePath = System.getProperty(JETTY_SSLCONTEXTFACTORY_KEYSTOREPATH);
            sslContextFactoryNeedClientAuth = Boolean.getBoolean(JETTY_SSLCONTEXTFACTORY_NEEDCLIENTAUTH);
            start = Boolean.getBoolean("org.jitsi.videobridge.rest");
            tlsPort = Integer.getInteger(JETTY_TLS_PORT_PNAME, tlsPort);
        } else {
            enableRestShutdown = cfg.getBoolean(ENABLE_REST_SHUTDOWN_PNAME, false);
            host = cfg.getString(JETTY_HOST_PNAME, host);
            port = cfg.getInt(JETTY_PORT_PNAME, port);
            sslContextFactoryKeyStorePassword = cfg.getString(JETTY_SSLCONTEXTFACTORY_KEYSTOREPASSWORD);
            sslContextFactoryKeyStorePath = cfg.getString(JETTY_SSLCONTEXTFACTORY_KEYSTOREPATH);
            sslContextFactoryNeedClientAuth = cfg.getBoolean(JETTY_SSLCONTEXTFACTORY_NEEDCLIENTAUTH, sslContextFactoryNeedClientAuth);
            start = cfg.getBoolean("org.jitsi.videobridge.rest", false);
            tlsPort = cfg.getInt(JETTY_TLS_PORT_PNAME, tlsPort);
        }
        if (!start) {
            return;
        }
        try {
            Server server = new Server();
            HttpConfiguration httpCfg = new HttpConfiguration();
            httpCfg.setSecurePort(tlsPort);
            httpCfg.setSecureScheme("https");
            if (sslContextFactoryKeyStorePath == null) {
                MuxServerConnector httpConnector = new MuxServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpCfg)});
                if (host != null) {
                    httpConnector.setHost(host);
                }
                httpConnector.setPort(port);
                server.addConnector((Connector)httpConnector);
            } else {
                File sslContextFactoryKeyStoreFile = ConfigUtils.getAbsoluteFile((String)sslContextFactoryKeyStorePath, (ConfigurationService)cfg);
                SslContextFactory sslContextFactory = new SslContextFactory();
                sslContextFactory.setExcludeCipherSuites(new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"});
                sslContextFactory.setIncludeCipherSuites(new String[]{".*RC4.*"});
                if (sslContextFactoryKeyStorePassword != null) {
                    sslContextFactory.setKeyStorePassword(sslContextFactoryKeyStorePassword);
                }
                sslContextFactory.setKeyStorePath(sslContextFactoryKeyStoreFile.getPath());
                sslContextFactory.setNeedClientAuth(sslContextFactoryNeedClientAuth);
                HttpConfiguration httpsCfg = new HttpConfiguration(httpCfg);
                httpsCfg.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                MuxServerConnector sslConnector = new MuxServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsCfg)});
                if (host != null) {
                    sslConnector.setHost(host);
                }
                sslConnector.setPort(tlsPort);
                server.addConnector((Connector)sslConnector);
            }
            server.setHandler((Handler)new HandlerImpl(bundleContext, enableRestShutdown));
            server.start();
            this.server = server;
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to start the REST API of Jitsi Videobridge.", t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new UndeclaredThrowableException(t);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.server != null) {
            Thread.sleep(1000L);
            this.server.stop();
            this.server = null;
        }
    }
}

