/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.net.InetSocketAddress;
import org.jitsi.impl.libjitsi.LibJitsiImpl;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.packetlogging.PacketLoggingService;

public class DebugTransformEngine
implements TransformEngine {
    private final MediaStreamImpl mediaStream;

    public DebugTransformEngine(MediaStreamImpl mediaStream) {
        this.mediaStream = mediaStream;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return new SinglePacketTransformer(){

            @Override
            public void close() {
            }

            @Override
            public RawPacket reverseTransform(RawPacket pkt) {
                PacketLoggingService packetLogging = LibJitsiImpl.getPacketLoggingService();
                if (packetLogging != null) {
                    byte[] byArray;
                    byte[] byArray2;
                    InetSocketAddress sourceAddress = DebugTransformEngine.this.mediaStream.getTarget().getDataAddress();
                    InetSocketAddress destinationAddress = DebugTransformEngine.this.mediaStream.getLocalDataAddress();
                    if (sourceAddress != null) {
                        byArray2 = sourceAddress.getAddress().getAddress();
                    } else {
                        byte[] byArray3 = new byte[4];
                        byArray3[0] = 0;
                        byArray3[1] = 0;
                        byArray3[2] = 0;
                        byArray2 = byArray3;
                        byArray3[3] = 0;
                    }
                    int n = sourceAddress != null ? sourceAddress.getPort() : 1;
                    if (destinationAddress != null) {
                        byArray = destinationAddress.getAddress().getAddress();
                    } else {
                        byte[] byArray4 = new byte[4];
                        byArray4[0] = 0;
                        byArray4[1] = 0;
                        byArray4[2] = 0;
                        byArray = byArray4;
                        byArray4[3] = 0;
                    }
                    packetLogging.logPacket(PacketLoggingService.ProtocolName.ARBITRARY, byArray2, n, byArray, destinationAddress != null ? destinationAddress.getPort() : 1, PacketLoggingService.TransportName.UDP, false, (byte[])pkt.getBuffer().clone(), pkt.getOffset(), pkt.getLength());
                }
                return pkt;
            }

            @Override
            public RawPacket transform(RawPacket pkt) {
                PacketLoggingService packetLogging = LibJitsiImpl.getPacketLoggingService();
                if (packetLogging != null) {
                    byte[] byArray;
                    byte[] byArray2;
                    InetSocketAddress sourceAddress = DebugTransformEngine.this.mediaStream.getLocalDataAddress();
                    InetSocketAddress destinationAddress = DebugTransformEngine.this.mediaStream.getTarget().getDataAddress();
                    if (sourceAddress != null) {
                        byArray2 = sourceAddress.getAddress().getAddress();
                    } else {
                        byte[] byArray3 = new byte[4];
                        byArray3[0] = 0;
                        byArray3[1] = 0;
                        byArray3[2] = 0;
                        byArray2 = byArray3;
                        byArray3[3] = 0;
                    }
                    int n = sourceAddress != null ? sourceAddress.getPort() : 1;
                    if (destinationAddress != null) {
                        byArray = destinationAddress.getAddress().getAddress();
                    } else {
                        byte[] byArray4 = new byte[4];
                        byArray4[0] = 0;
                        byArray4[1] = 0;
                        byArray4[2] = 0;
                        byArray = byArray4;
                        byArray4[3] = 0;
                    }
                    packetLogging.logPacket(PacketLoggingService.ProtocolName.ARBITRARY, byArray2, n, byArray, destinationAddress != null ? destinationAddress.getPort() : 1, PacketLoggingService.TransportName.UDP, true, (byte[])pkt.getBuffer().clone(), pkt.getOffset(), pkt.getLength());
                }
                return pkt;
            }
        };
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return new SinglePacketTransformer(){

            @Override
            public void close() {
            }

            @Override
            public RawPacket reverseTransform(RawPacket pkt) {
                PacketLoggingService packetLogging = LibJitsiImpl.getPacketLoggingService();
                if (packetLogging != null) {
                    byte[] byArray;
                    byte[] byArray2;
                    InetSocketAddress sourceAddress = DebugTransformEngine.this.mediaStream.getTarget().getControlAddress();
                    InetSocketAddress destinationAddress = DebugTransformEngine.this.mediaStream.getLocalControlAddress();
                    if (sourceAddress != null) {
                        byArray2 = sourceAddress.getAddress().getAddress();
                    } else {
                        byte[] byArray3 = new byte[4];
                        byArray3[0] = 0;
                        byArray3[1] = 0;
                        byArray3[2] = 0;
                        byArray2 = byArray3;
                        byArray3[3] = 0;
                    }
                    int n = sourceAddress != null ? sourceAddress.getPort() : 1;
                    if (destinationAddress != null) {
                        byArray = destinationAddress.getAddress().getAddress();
                    } else {
                        byte[] byArray4 = new byte[4];
                        byArray4[0] = 0;
                        byArray4[1] = 0;
                        byArray4[2] = 0;
                        byArray = byArray4;
                        byArray4[3] = 0;
                    }
                    packetLogging.logPacket(PacketLoggingService.ProtocolName.ARBITRARY, byArray2, n, byArray, destinationAddress != null ? destinationAddress.getPort() : 1, PacketLoggingService.TransportName.UDP, false, (byte[])pkt.getBuffer().clone(), pkt.getOffset(), pkt.getLength());
                }
                return pkt;
            }

            @Override
            public RawPacket transform(RawPacket pkt) {
                PacketLoggingService packetLogging = LibJitsiImpl.getPacketLoggingService();
                if (packetLogging != null) {
                    byte[] byArray;
                    byte[] byArray2;
                    InetSocketAddress sourceAddress = DebugTransformEngine.this.mediaStream.getLocalControlAddress();
                    InetSocketAddress destinationAddress = DebugTransformEngine.this.mediaStream.getTarget().getControlAddress();
                    if (sourceAddress != null) {
                        byArray2 = sourceAddress.getAddress().getAddress();
                    } else {
                        byte[] byArray3 = new byte[4];
                        byArray3[0] = 0;
                        byArray3[1] = 0;
                        byArray3[2] = 0;
                        byArray2 = byArray3;
                        byArray3[3] = 0;
                    }
                    int n = sourceAddress != null ? sourceAddress.getPort() : 1;
                    if (destinationAddress != null) {
                        byArray = destinationAddress.getAddress().getAddress();
                    } else {
                        byte[] byArray4 = new byte[4];
                        byArray4[0] = 0;
                        byArray4[1] = 0;
                        byArray4[2] = 0;
                        byArray = byArray4;
                        byArray4[3] = 0;
                    }
                    packetLogging.logPacket(PacketLoggingService.ProtocolName.ARBITRARY, byArray2, n, byArray, destinationAddress != null ? destinationAddress.getPort() : 1, PacketLoggingService.TransportName.UDP, true, (byte[])pkt.getBuffer().clone(), pkt.getOffset(), pkt.getLength());
                }
                return pkt;
            }
        };
    }
}

