/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.protocol;

import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.protocol.StreamSubstituteBufferTransferHandler;

public class CachingPushBufferStream
implements PushBufferStream {
    public static final long DEFAULT_BUFFER_LENGTH = 20L;
    private static final int MAX_CACHE_SIZE = 1024;
    private BufferControl bufferControl;
    private final Object bufferControlSyncRoot = new Object();
    private final List<Buffer> cache = new LinkedList<Buffer>();
    private long cacheLengthInMillis = 0L;
    private IOException readException;
    private final PushBufferStream stream;
    private BufferTransferHandler transferHandler;

    public CachingPushBufferStream(PushBufferStream stream) {
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canWriteInCache() {
        List<Buffer> list = this.cache;
        synchronized (list) {
            int cacheSize = this.cache.size();
            if (cacheSize < 1) {
                return true;
            }
            if (cacheSize >= 1024) {
                return false;
            }
            long bufferLength = this.getBufferLength();
            if (bufferLength < 1L) {
                return false;
            }
            if (this.cacheLengthInMillis < 1L) {
                return false;
            }
            return this.cacheLengthInMillis < bufferLength;
        }
    }

    @Override
    public boolean endOfStream() {
        return this.stream.endOfStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferControl getBufferControl() {
        Object object = this.bufferControlSyncRoot;
        synchronized (object) {
            if (this.bufferControl == null) {
                this.bufferControl = new BufferControlImpl();
            }
            return this.bufferControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getBufferLength() {
        Object object = this.bufferControlSyncRoot;
        synchronized (object) {
            return this.bufferControl == null ? -1L : this.bufferControl.getBufferLength();
        }
    }

    @Override
    public ContentDescriptor getContentDescriptor() {
        return this.stream.getContentDescriptor();
    }

    @Override
    public long getContentLength() {
        return this.stream.getContentLength();
    }

    @Override
    public Object getControl(String controlType) {
        Object control = this.stream.getControl(controlType);
        if (control == null && BufferControl.class.getName().equals(controlType)) {
            control = this.getBufferControl();
        }
        return control;
    }

    @Override
    public Object[] getControls() {
        Object[] controls = this.stream.getControls();
        if (controls == null) {
            BufferControl bufferControl = this.getBufferControl();
            if (bufferControl != null) {
                controls = new Object[]{bufferControl};
            }
        } else {
            BufferControl bufferControl;
            boolean bufferControlExists = false;
            for (Object control : controls) {
                if (!(control instanceof BufferControl)) continue;
                bufferControlExists = true;
                break;
            }
            if (!bufferControlExists && (bufferControl = this.getBufferControl()) != null) {
                Object[] newControls = new Object[controls.length + 1];
                newControls[0] = bufferControl;
                System.arraycopy(controls, 0, newControls, 1, controls.length);
            }
        }
        return controls;
    }

    @Override
    public Format getFormat() {
        return this.stream.getFormat();
    }

    private long getLengthInMillis(Buffer buffer) {
        int length = buffer.getLength();
        if (length < 1) {
            return 0L;
        }
        Format format = buffer.getFormat();
        if (format == null && (format = this.getFormat()) == null) {
            return 0L;
        }
        if (!(format instanceof AudioFormat)) {
            return 0L;
        }
        AudioFormat audioFormat = (AudioFormat)format;
        long duration = audioFormat.computeDuration(length);
        return duration < 1L ? 0L : duration / 1000000L;
    }

    public PushBufferStream getStream() {
        return this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(Buffer buffer) throws IOException {
        List<Buffer> list = this.cache;
        synchronized (list) {
            if (this.readException != null) {
                IOException ioe = new IOException();
                ioe.initCause(this.readException);
                this.readException = null;
                throw ioe;
            }
            buffer.setLength(0);
            if (!this.cache.isEmpty()) {
                int bufferOffset = buffer.getOffset();
                while (!this.cache.isEmpty()) {
                    Buffer cacheBuffer = this.cache.get(0);
                    int nextBufferOffset = this.read(cacheBuffer, buffer, bufferOffset);
                    if (cacheBuffer.getLength() <= 0 || cacheBuffer.getData() == null) {
                        this.cache.remove(0);
                    }
                    if (nextBufferOffset < 0) break;
                    bufferOffset = nextBufferOffset;
                }
                this.cacheLengthInMillis -= this.getLengthInMillis(buffer);
                if (this.cacheLengthInMillis < 0L) {
                    this.cacheLengthInMillis = 0L;
                }
                if (this.canWriteInCache()) {
                    this.cache.notify();
                }
            }
        }
    }

    private int read(Buffer in, Buffer out, int outOffset) throws IOException {
        Object outData = out.getData();
        if (outData != null) {
            Object inData = in.getData();
            if (inData == null) {
                out.setFormat(in.getFormat());
                return outOffset;
            }
            Class<?> dataType = outData.getClass();
            if (inData.getClass().equals(dataType) && dataType.equals(byte[].class)) {
                int inOffset = in.getOffset();
                int inLength = in.getLength();
                byte[] outBytes = (byte[])outData;
                int outLength = outBytes.length - outOffset;
                if (outLength < 1) {
                    return -1;
                }
                if (inLength < outLength) {
                    outLength = inLength;
                }
                System.arraycopy(inData, inOffset, outBytes, outOffset, outLength);
                out.setData(outBytes);
                out.setLength(out.getLength() + outLength);
                if (out.getOffset() == outOffset) {
                    out.setFormat(in.getFormat());
                    out.setDiscard(in.isDiscard());
                    out.setEOM(in.isEOM());
                    out.setFlags(in.getFlags());
                    out.setHeader(in.getHeader());
                    out.setSequenceNumber(in.getSequenceNumber());
                    out.setTimeStamp(in.getTimeStamp());
                    out.setRtpTimeStamp(in.getRtpTimeStamp());
                    out.setHeaderExtension(in.getHeaderExtension());
                    out.setDuration(-1L);
                }
                in.setLength(inLength - outLength);
                in.setOffset(inOffset + outLength);
                return outOffset + outLength;
            }
        }
        if (out.getOffset() == outOffset) {
            out.copy(in);
            int outputLength = out.getLength();
            in.setLength(in.getLength() - outputLength);
            in.setOffset(in.getOffset() + outputLength);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransferHandler(BufferTransferHandler transferHandler) {
        StreamSubstituteBufferTransferHandler substituteTransferHandler = transferHandler == null ? null : new StreamSubstituteBufferTransferHandler(transferHandler, this.stream, this){

            @Override
            public void transferData(PushBufferStream stream) {
                if (CachingPushBufferStream.this.stream == stream) {
                    CachingPushBufferStream.this.transferData(this);
                }
                super.transferData(stream);
            }
        };
        List<Buffer> list = this.cache;
        synchronized (list) {
            this.stream.setTransferHandler(substituteTransferHandler);
            this.transferHandler = substituteTransferHandler;
            this.cache.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferData(BufferTransferHandler transferHandler) {
        boolean interrupted = false;
        boolean canWriteInCache = false;
        List<Buffer> list = this.cache;
        synchronized (list) {
            while (true) {
                if (this.transferHandler != transferHandler) {
                    canWriteInCache = false;
                    break;
                }
                if (this.canWriteInCache()) {
                    canWriteInCache = true;
                    break;
                }
                try {
                    this.cache.wait(10L);
                }
                catch (InterruptedException iex) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        } else if (canWriteInCache) {
            IOException readException;
            Buffer buffer = new Buffer();
            try {
                this.stream.read(buffer);
                readException = null;
            }
            catch (IOException ioe) {
                readException = ioe;
            }
            if (readException == null) {
                if (!buffer.isDiscard() && buffer.getLength() != 0 && buffer.getData() != null) {
                    List<Buffer> list2 = this.cache;
                    synchronized (list2) {
                        this.cache.add(buffer);
                        this.cacheLengthInMillis += this.getLengthInMillis(buffer);
                    }
                }
            } else {
                List<Buffer> list3 = this.cache;
                synchronized (list3) {
                    this.readException = readException;
                }
            }
        }
    }

    private static class BufferControlImpl
    implements BufferControl {
        private long bufferLength = -1L;
        private boolean enabledThreshold;
        private long minimumThreshold = -1L;

        private BufferControlImpl() {
        }

        @Override
        public long getBufferLength() {
            return this.bufferLength;
        }

        @Override
        public Component getControlComponent() {
            return null;
        }

        @Override
        public boolean getEnabledThreshold() {
            return this.enabledThreshold;
        }

        @Override
        public long getMinimumThreshold() {
            return this.minimumThreshold;
        }

        @Override
        public long setBufferLength(long bufferLength) {
            if (bufferLength == -1L || bufferLength > 0L) {
                this.bufferLength = bufferLength;
            }
            return this.getBufferLength();
        }

        @Override
        public void setEnabledThreshold(boolean enabledThreshold) {
            this.enabledThreshold = enabledThreshold;
        }

        @Override
        public long setMinimumThreshold(long minimumThreshold) {
            return this.getMinimumThreshold();
        }
    }
}

