/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.audiolevel;

public class AudioLevelMap {
    private long[][] levels = null;

    public void putLevel(long csrc, int level) {
        long[][] levelsRef = this.levels;
        int csrcIndex = this.findCSRC(levelsRef, csrc);
        if (csrcIndex == -1) {
            this.levels = this.appendCSRCToMatrix(levelsRef, csrc, level);
        } else {
            levelsRef[csrcIndex][1] = level;
        }
    }

    public boolean removeLevel(long csrc) {
        long[][] levelsRef = this.levels;
        int index = this.findCSRC(levelsRef, csrc);
        if (index == -1) {
            return false;
        }
        if (levelsRef.length == 1) {
            this.levels = null;
            return true;
        }
        long[][] newLevelsRef = new long[levelsRef.length - 1][];
        System.arraycopy(levelsRef, 0, newLevelsRef, 0, index);
        System.arraycopy(levelsRef, index + 1, newLevelsRef, index, newLevelsRef.length - index);
        this.levels = newLevelsRef;
        return true;
    }

    public int getLevel(long csrc) {
        long[][] levelsRef = this.levels;
        int index = this.findCSRC(levelsRef, csrc);
        return index == -1 ? -1 : (int)levelsRef[index][1];
    }

    private int findCSRC(long[][] levels, long csrc) {
        if (levels != null) {
            for (int i = 0; i < levels.length; ++i) {
                if (levels[i][0] != csrc) continue;
                return i;
            }
        }
        return -1;
    }

    private long[][] appendCSRCToMatrix(long[][] levels, long csrc, int level) {
        int newLength = 1 + (levels == null ? 0 : levels.length);
        long[][] newLevels = new long[newLength][];
        newLevels[0] = new long[]{csrc, level};
        if (newLength == 1) {
            return newLevels;
        }
        System.arraycopy(levels, 0, newLevels, 1, levels.length);
        return newLevels;
    }
}

