/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.DatagramPacket;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.control.FormatControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.DatagramPacketListener;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.QualityControlImpl;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.control.ImgStreamingControl;
import org.jitsi.impl.neomedia.device.DeviceConfiguration;
import org.jitsi.impl.neomedia.device.MediaDeviceImpl;
import org.jitsi.impl.neomedia.device.MediaDeviceSession;
import org.jitsi.impl.neomedia.device.ScreenDeviceImpl;
import org.jitsi.impl.neomedia.device.VideoMediaDeviceSession;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RecurringProcessible;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RecurringProcessibleExecutor;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RemoteBitrateEstimatorSingleStream;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RemoteBitrateObserver;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.transform.REDFilterTransformEngine;
import org.jitsi.service.neomedia.QualityControl;
import org.jitsi.service.neomedia.QualityPreset;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.control.KeyFrameControl;
import org.jitsi.service.neomedia.control.KeyFrameControlAdapter;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.device.ScreenDevice;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.service.neomedia.rtp.RemoteBitrateEstimator;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;
import org.jitsi.util.event.VideoEvent;
import org.jitsi.util.event.VideoListener;
import org.jitsi.util.event.VideoNotifierSupport;

public class VideoMediaStreamImpl
extends MediaStreamImpl
implements VideoMediaStream {
    private static final Logger logger = Logger.getLogger(VideoMediaStreamImpl.class);
    private static final RecurringProcessibleExecutor recurringProcessibleExecutor = new RecurringProcessibleExecutor();
    private static final boolean USE_RTCP_FEEDBACK_PLI = true;
    private REDFilterTransformEngine redFilterTransformEngine = new REDFilterTransformEngine();
    private VideoListener deviceSessionVideoListener;
    private KeyFrameControl keyFrameControl;
    private Dimension outputSize;
    private final QualityControlImpl qualityControl = new QualityControlImpl();
    private final RemoteBitrateEstimator remoteBitrateEstimator = new RemoteBitrateEstimatorSingleStream(new RemoteBitrateObserver(){

        @Override
        public void onReceiveBitrateChanged(Collection<Integer> ssrcs, long bitrate) {
            VideoMediaStreamImpl.this.remoteBitrateEstimatorOnReceiveBitrateChanged(ssrcs, bitrate);
        }
    }, 0L);
    private final VideoNotifierSupport videoNotifierSupport = new VideoNotifierSupport(this, true);

    @Override
    protected REDFilterTransformEngine getRedFilterTransformEngine() {
        return this.redFilterTransformEngine;
    }

    public static Dimension[] parseSendRecvResolution(String imgattr) {
        int i;
        int[] val;
        Dimension[] res = new Dimension[2];
        String token = null;
        Pattern pSendSingle = Pattern.compile("send \\[x=[0-9]+,y=[0-9]+\\]");
        Pattern pRecvSingle = Pattern.compile("recv \\[x=[0-9]+,y=[0-9]+\\]");
        Pattern pSendRange = Pattern.compile("send \\[x=\\[[0-9]+-[0-9]+\\],y=\\[[0-9]+-[0-9]+\\]\\]");
        Pattern pRecvRange = Pattern.compile("recv \\[x=\\[[0-9]+-[0-9]+\\],y=\\[[0-9]+-[0-9]+\\]\\]");
        Pattern pNumeric = Pattern.compile("[0-9]+");
        Matcher mSingle = null;
        Matcher mRange = null;
        Matcher m = null;
        mSingle = pSendSingle.matcher(imgattr);
        mRange = pSendRange.matcher(imgattr);
        if (mSingle.find()) {
            val = new int[2];
            i = 0;
            token = imgattr.substring(mSingle.start(), mSingle.end());
            m = pNumeric.matcher(token);
            while (m.find() && i < 2) {
                val[i] = Integer.parseInt(token.substring(m.start(), m.end()));
            }
            res[0] = new Dimension(val[0], val[1]);
        } else if (mRange.find()) {
            val = new int[4];
            token = imgattr.substring(mRange.start(), mRange.end());
            m = pNumeric.matcher(token);
            for (i = 0; m.find() && i < 4; ++i) {
                val[i] = Integer.parseInt(token.substring(m.start(), m.end()));
            }
            res[0] = new Dimension(val[1], val[3]);
        }
        mSingle = pRecvSingle.matcher(imgattr);
        mRange = pRecvRange.matcher(imgattr);
        if (mSingle.find()) {
            val = new int[2];
            i = 0;
            token = imgattr.substring(mSingle.start(), mSingle.end());
            m = pNumeric.matcher(token);
            while (m.find() && i < 2) {
                val[i] = Integer.parseInt(token.substring(m.start(), m.end()));
            }
            res[1] = new Dimension(val[0], val[1]);
        } else if (mRange.find()) {
            val = new int[4];
            token = imgattr.substring(mRange.start(), mRange.end());
            m = pNumeric.matcher(token);
            for (i = 0; m.find() && i < 4; ++i) {
                val[i] = Integer.parseInt(token.substring(m.start(), m.end()));
            }
            res[1] = new Dimension(val[1], val[3]);
        }
        return res;
    }

    public static Dimension selectVideoSize(DataSource videoDS, final int preferredWidth, final int preferredHeight) {
        if (videoDS == null) {
            return null;
        }
        FormatControl formatControl = (FormatControl)videoDS.getControl(FormatControl.class.getName());
        if (formatControl == null) {
            return null;
        }
        Format[] formats = formatControl.getSupportedFormats();
        int count = formats.length;
        if (count < 1) {
            return null;
        }
        VideoFormat selectedFormat = null;
        if (count == 1) {
            selectedFormat = (VideoFormat)formats[0];
        } else {
            class FormatInfo {
                public final double difference;
                public final Dimension dimension;
                public final VideoFormat format;

                public FormatInfo(Dimension size) {
                    this.format = null;
                    this.dimension = size;
                    this.difference = this.getDifference(this.dimension);
                }

                public FormatInfo(VideoFormat format) {
                    this.format = format;
                    this.dimension = format.getSize();
                    this.difference = this.getDifference(this.dimension);
                }

                private double getDifference(Dimension size) {
                    int height;
                    int width;
                    int n = width = size == null ? 0 : size.width;
                    double xScale = width == 0 ? Double.POSITIVE_INFINITY : (width == preferredWidth ? 1.0 : (double)preferredWidth / (double)width);
                    int n2 = height = size == null ? 0 : size.height;
                    double yScale = height == 0 ? Double.POSITIVE_INFINITY : (height == preferredHeight ? 1.0 : (double)preferredHeight / (double)height);
                    return Math.abs(1.0 - Math.min(xScale, yScale));
                }
            }
            FormatInfo[] infos = new FormatInfo[count];
            for (int i = 0; i < count; ++i) {
                FormatInfo info = infos[i] = new FormatInfo((VideoFormat)formats[i]);
                if (info.difference != 0.0) continue;
                selectedFormat = info.format;
                break;
            }
            if (selectedFormat == null) {
                Arrays.sort(infos, new Comparator<FormatInfo>(){

                    @Override
                    public int compare(FormatInfo info0, FormatInfo info1) {
                        return Double.compare(info0.difference, info1.difference);
                    }
                });
                selectedFormat = infos[0].format;
            }
            if (selectedFormat != null && selectedFormat.getSize() == null) {
                VideoFormat currentFormat = (VideoFormat)formatControl.getFormat();
                Dimension currentSize = null;
                int width = preferredWidth;
                int height = preferredHeight;
                if (currentFormat != null) {
                    currentSize = currentFormat.getSize();
                }
                FormatInfo[] supportedInfos = new FormatInfo[DeviceConfiguration.SUPPORTED_RESOLUTIONS.length];
                for (int i = 0; i < supportedInfos.length; ++i) {
                    supportedInfos[i] = new FormatInfo(DeviceConfiguration.SUPPORTED_RESOLUTIONS[i]);
                }
                Arrays.sort(infos, new Comparator<FormatInfo>(){

                    @Override
                    public int compare(FormatInfo info0, FormatInfo info1) {
                        return Double.compare(info0.difference, info1.difference);
                    }
                });
                FormatInfo preferredFormat = new FormatInfo(new Dimension(preferredWidth, preferredHeight));
                Dimension closestAspect = null;
                for (FormatInfo supported : supportedInfos) {
                    if (preferredFormat.difference > supported.difference) continue;
                    if (closestAspect == null) {
                        closestAspect = supported.dimension;
                    }
                    if (supported.dimension.height > preferredHeight || supported.dimension.width > preferredWidth) continue;
                    currentSize = supported.dimension;
                }
                if (currentSize == null) {
                    currentSize = closestAspect;
                }
                if (currentSize.width > 0 && currentSize.height > 0) {
                    width = currentSize.width;
                    height = currentSize.height;
                }
                selectedFormat = (VideoFormat)new VideoFormat(null, new Dimension(width, height), -1, null, -1.0f).intersects(selectedFormat);
            }
        }
        Format setFormat = formatControl.setFormat(selectedFormat);
        return setFormat instanceof VideoFormat ? ((VideoFormat)setFormat).getSize() : null;
    }

    public VideoMediaStreamImpl(StreamConnector connector, MediaDevice device, SrtpControl srtpControl) {
        super(connector, device, srtpControl);
        RemoteBitrateEstimator remoteBitrateEstimator = this.getRemoteBitrateEstimator();
        if (remoteBitrateEstimator instanceof RecurringProcessible) {
            recurringProcessibleExecutor.registerRecurringProcessible((RecurringProcessible)((Object)remoteBitrateEstimator));
        }
    }

    @Override
    protected void addRemoteSourceID(long ssrc) {
        super.addRemoteSourceID(ssrc);
        MediaDeviceSession deviceSession = this.getDeviceSession();
        if (deviceSession instanceof VideoMediaDeviceSession) {
            ((VideoMediaDeviceSession)deviceSession).setRemoteSSRC(ssrc);
        }
    }

    @Override
    public void addVideoListener(VideoListener listener) {
        this.videoNotifierSupport.addVideoListener(listener);
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            RemoteBitrateEstimator remoteBitrateEstimator = this.getRemoteBitrateEstimator();
            if (remoteBitrateEstimator instanceof RecurringProcessible) {
                recurringProcessibleExecutor.deRegisterRecurringProcessible((RecurringProcessible)((Object)remoteBitrateEstimator));
            }
        }
    }

    @Override
    protected void configureDataInputStream(RTPConnectorInputStream<?> dataInputStream) {
        super.configureDataInputStream(dataInputStream);
        dataInputStream.addDatagramPacketListener(new DatagramPacketListener(){

            @Override
            public void update(Object source, DatagramPacket p) {
                VideoMediaStreamImpl.this.dataInputStreamDatagramPacketListenerUpdate(source, p);
            }
        });
    }

    @Override
    protected void configureDataOutputStream(RTPConnectorOutputStream dataOutputStream) {
        int maxBandwidth;
        super.configureDataOutputStream(dataOutputStream);
        if (!OSUtils.IS_ANDROID && (maxBandwidth = NeomediaServiceUtils.getMediaServiceImpl().getDeviceConfiguration().getVideoRTPPacingThreshold()) <= 1000) {
            dataOutputStream.setMaxPacketsPerMillis(1, 1000 / maxBandwidth);
        }
    }

    @Override
    protected void configureRTPManagerBufferControl(StreamRTPManager rtpManager, BufferControl bufferControl) {
        super.configureRTPManagerBufferControl(rtpManager, bufferControl);
        bufferControl.setBufferLength(-2L);
    }

    private void dataInputStreamDatagramPacketListenerUpdate(Object source, DatagramPacket p) {
        int off;
        byte[] buf;
        long payloadLenAndOff;
        RemoteBitrateEstimator remoteBitrateEstimator = this.getRemoteBitrateEstimator();
        if (remoteBitrateEstimator != null && (payloadLenAndOff = RTPTranslatorImpl.getPayloadLengthAndOffsetIfRTP(buf = p.getData(), off = p.getOffset(), p.getLength())) >= 0L) {
            int payloadLen = (int)(payloadLenAndOff >>> 32);
            int payloadOff = (int)payloadLenAndOff;
            if (payloadOff >= 0) {
                long arrivalTimeMs = System.currentTimeMillis();
                long timestamp = (long)RTPTranslatorImpl.readInt(buf, off + 4) & 0xFFFFFFFFL;
                int ssrc = RTPTranslatorImpl.readInt(buf, off + 8);
                remoteBitrateEstimator.incomingPacket(arrivalTimeMs, payloadLen, ssrc, timestamp);
            }
        }
    }

    @Override
    protected void deviceSessionChanged(MediaDeviceSession oldValue, MediaDeviceSession newValue) {
        super.deviceSessionChanged(oldValue, newValue);
        if (oldValue instanceof VideoMediaDeviceSession) {
            VideoMediaDeviceSession oldVideoMediaDeviceSession = (VideoMediaDeviceSession)oldValue;
            if (this.deviceSessionVideoListener != null) {
                oldVideoMediaDeviceSession.removeVideoListener(this.deviceSessionVideoListener);
            }
            oldVideoMediaDeviceSession.setKeyFrameControl(null);
        }
        if (newValue instanceof VideoMediaDeviceSession) {
            VideoMediaDeviceSession newVideoMediaDeviceSession = (VideoMediaDeviceSession)newValue;
            if (this.deviceSessionVideoListener == null) {
                this.deviceSessionVideoListener = new VideoListener(){

                    @Override
                    public void videoAdded(VideoEvent e) {
                        if (VideoMediaStreamImpl.this.fireVideoEvent(e.getType(), e.getVisualComponent(), e.getOrigin(), true)) {
                            e.consume();
                        }
                    }

                    @Override
                    public void videoRemoved(VideoEvent e) {
                        this.videoAdded(e);
                    }

                    @Override
                    public void videoUpdate(VideoEvent e) {
                        VideoMediaStreamImpl.this.fireVideoEvent(e, true);
                    }
                };
            }
            newVideoMediaDeviceSession.addVideoListener(this.deviceSessionVideoListener);
            newVideoMediaDeviceSession.setOutputSize(this.outputSize);
            AbstractRTPConnector rtpConnector = this.getRTPConnector();
            if (rtpConnector != null) {
                newVideoMediaDeviceSession.setConnector(rtpConnector);
            }
            newVideoMediaDeviceSession.setRTCPFeedbackPLI(true);
            newVideoMediaDeviceSession.setKeyFrameControl(this.getKeyFrameControl());
        }
    }

    protected boolean fireVideoEvent(int type, Component visualComponent, int origin, boolean wait) {
        if (logger.isTraceEnabled()) {
            logger.trace("Firing VideoEvent with type " + VideoEvent.typeToString(type) + " and origin " + VideoEvent.originToString(origin));
        }
        return this.videoNotifierSupport.fireVideoEvent(type, visualComponent, origin, wait);
    }

    protected void fireVideoEvent(VideoEvent event, boolean wait) {
        this.videoNotifierSupport.fireVideoEvent(event, wait);
    }

    @Override
    public KeyFrameControl getKeyFrameControl() {
        if (this.keyFrameControl == null) {
            this.keyFrameControl = new KeyFrameControlAdapter();
        }
        return this.keyFrameControl;
    }

    @Override
    public Component getLocalVisualComponent() {
        MediaDeviceSession deviceSession = this.getDeviceSession();
        return deviceSession instanceof VideoMediaDeviceSession ? ((VideoMediaDeviceSession)deviceSession).getLocalVisualComponent() : null;
    }

    @Override
    protected int getPriority() {
        return 5;
    }

    @Override
    public QualityControl getQualityControl() {
        return this.qualityControl;
    }

    @Override
    public RemoteBitrateEstimator getRemoteBitrateEstimator() {
        return this.remoteBitrateEstimator;
    }

    @Override
    @Deprecated
    public Component getVisualComponent() {
        List<Component> visualComponents = this.getVisualComponents();
        return visualComponents.isEmpty() ? null : visualComponents.get(0);
    }

    @Override
    public Component getVisualComponent(long ssrc) {
        MediaDeviceSession deviceSession = this.getDeviceSession();
        return deviceSession instanceof VideoMediaDeviceSession ? ((VideoMediaDeviceSession)deviceSession).getVisualComponent(ssrc) : null;
    }

    @Override
    public List<Component> getVisualComponents() {
        MediaDeviceSession deviceSession = this.getDeviceSession();
        List<Component> visualComponents = deviceSession instanceof VideoMediaDeviceSession ? ((VideoMediaDeviceSession)deviceSession).getVisualComponents() : Collections.emptyList();
        return visualComponents;
    }

    @Override
    protected void handleAttributes(MediaFormat format, Map<String, String> attrs) {
        if (attrs != null) {
            String width = null;
            String height = null;
            for (Map.Entry<String, String> attr : attrs.entrySet()) {
                Dimension dim;
                String key = attr.getKey();
                String value = attr.getValue();
                if (key.equals("rtcp-fb")) continue;
                if (key.equals("imageattr")) {
                    Dimension[] res;
                    if ((attrs.containsKey("width") || attrs.containsKey("height")) && this.outputSize != null || (res = VideoMediaStreamImpl.parseSendRecvResolution(value)) == null) continue;
                    this.setOutputSize(res[1]);
                    this.qualityControl.setRemoteSendMaxPreset(new QualityPreset(res[0]));
                    this.qualityControl.setRemoteReceiveResolution(this.outputSize);
                    ((VideoMediaDeviceSession)this.getDeviceSession()).setOutputSize(this.outputSize);
                    continue;
                }
                if (key.equals("CIF")) {
                    dim = new Dimension(352, 288);
                    if (this.outputSize != null && (this.outputSize.width >= dim.width || this.outputSize.height >= dim.height)) continue;
                    this.setOutputSize(dim);
                    ((VideoMediaDeviceSession)this.getDeviceSession()).setOutputSize(this.outputSize);
                    continue;
                }
                if (key.equals("QCIF")) {
                    dim = new Dimension(176, 144);
                    if (this.outputSize != null && (this.outputSize.width >= dim.width || this.outputSize.height >= dim.height)) continue;
                    this.setOutputSize(dim);
                    ((VideoMediaDeviceSession)this.getDeviceSession()).setOutputSize(this.outputSize);
                    continue;
                }
                if (key.equals("VGA")) {
                    dim = new Dimension(640, 480);
                    if (this.outputSize != null && (this.outputSize.width >= dim.width || this.outputSize.height >= dim.height)) continue;
                    this.setOutputSize(dim);
                    ((VideoMediaDeviceSession)this.getDeviceSession()).setOutputSize(this.outputSize);
                    continue;
                }
                if (key.equals("CUSTOM")) {
                    String[] args = value.split(",");
                    if (args.length < 3) continue;
                    try {
                        Dimension dim2 = new Dimension(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
                        if (this.outputSize != null && (this.outputSize.width >= dim2.width || this.outputSize.height >= dim2.height)) continue;
                        this.setOutputSize(dim2);
                        ((VideoMediaDeviceSession)this.getDeviceSession()).setOutputSize(this.outputSize);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (key.equals("width")) {
                    width = value;
                    if (height == null) continue;
                    this.setOutputSize(new Dimension(Integer.parseInt(width), Integer.parseInt(height)));
                    ((VideoMediaDeviceSession)this.getDeviceSession()).setOutputSize(this.outputSize);
                    continue;
                }
                if (!key.equals("height")) continue;
                height = value;
                if (width == null) continue;
                this.setOutputSize(new Dimension(Integer.parseInt(width), Integer.parseInt(height)));
                ((VideoMediaDeviceSession)this.getDeviceSession()).setOutputSize(this.outputSize);
            }
        }
    }

    @Override
    public void movePartialDesktopStreaming(int x, int y) {
        MediaDeviceImpl dev = (MediaDeviceImpl)this.getDevice();
        if (!"imgstreaming".equals(dev.getCaptureDeviceInfoLocatorProtocol())) {
            return;
        }
        DataSource captureDevice = this.getDeviceSession().getCaptureDevice();
        Object imgStreamingControl = captureDevice.getControl(ImgStreamingControl.class.getName());
        if (imgStreamingControl == null) {
            return;
        }
        ScreenDevice screen = NeomediaServiceUtils.getMediaServiceImpl().getScreenForPoint(new Point(x < 0 ? 0 : x, y < 0 ? 0 : y));
        if (screen != null) {
            Rectangle bounds = ((ScreenDeviceImpl)screen).getBounds();
            ((ImgStreamingControl)imgStreamingControl).setOrigin(0, screen.getIndex(), x - bounds.x, y - bounds.y);
        }
    }

    private void remoteBitrateEstimatorOnReceiveBitrateChanged(Collection<Integer> ssrcs, long bitrate) {
    }

    @Override
    public void removeVideoListener(VideoListener listener) {
        this.videoNotifierSupport.removeVideoListener(listener);
    }

    @Override
    protected void rtpConnectorChanged(AbstractRTPConnector oldValue, AbstractRTPConnector newValue) {
        MediaDeviceSession deviceSession;
        super.rtpConnectorChanged(oldValue, newValue);
        if (newValue != null && (deviceSession = this.getDeviceSession()) instanceof VideoMediaDeviceSession) {
            ((VideoMediaDeviceSession)deviceSession).setConnector(newValue);
        }
    }

    @Override
    protected void setLocalSourceID(long localSourceID) {
        super.setLocalSourceID(localSourceID);
        MediaDeviceSession deviceSession = this.getDeviceSession();
        if (deviceSession instanceof VideoMediaDeviceSession) {
            ((VideoMediaDeviceSession)deviceSession).setLocalSSRC(localSourceID);
        }
    }

    private void setOutputSize(Dimension outputSize) {
        this.outputSize = outputSize;
    }

    @Override
    public void updateQualityControl(Map<String, String> advancedParams) {
        for (Map.Entry<String, String> entry : advancedParams.entrySet()) {
            Dimension[] res;
            if (!entry.getKey().equals("imageattr") || (res = VideoMediaStreamImpl.parseSendRecvResolution(entry.getValue())) == null) continue;
            this.qualityControl.setRemoteSendMaxPreset(new QualityPreset(res[0]));
            this.qualityControl.setRemoteReceiveResolution(res[1]);
            this.setOutputSize(res[1]);
            ((VideoMediaDeviceSession)this.getDeviceSession()).setOutputSize(this.outputSize);
        }
    }
}

