/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.ice4j.ice.harvest.GoogleTurnSSLCandidateHarvester;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.DelegatingServerSocket;
import org.ice4j.socket.DelegatingServerSocketChannel;
import org.ice4j.socket.HttpDemuxFilter;
import org.ice4j.socket.PreReadSocketChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuxServerSocketChannel
extends DelegatingServerSocketChannel<MuxingServerSocketChannel> {
    private static final int SOCKET_CHANNEL_READ_CAPACITY = Math.max(GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE.length, Math.max(HttpDemuxFilter.REQUEST_METHOD_MAX_LENGTH + 1, 11));
    public static final int SOCKET_CHANNEL_READ_TIMEOUT = 15000;
    public static final String SOCKET_REUSE_ADDRESS_PROPERTY_NAME = "socket.reuseAddress";
    private final Queue<SocketChannel> acceptQ = new LinkedList<SocketChannel>();
    protected final DatagramPacketFilter filter;
    private final Object syncRoot = new Object();

    public static <T> T assertIsNotNull(T t, String message) throws NullPointerException {
        if (t == null) {
            throw new NullPointerException(message);
        }
        return t;
    }

    public static void closeNoExceptions(Channel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static MuxServerSocketChannel openAndBind(Map<String, Object> properties, SocketAddress endpoint, int backlog, DatagramPacketFilter filter) throws IOException {
        return MuxingServerSocketChannel.openAndBind(properties, endpoint, backlog, filter);
    }

    protected MuxServerSocketChannel(MuxingServerSocketChannel delegate, DatagramPacketFilter filter) {
        super((ServerSocketChannel)MuxServerSocketChannel.assertIsNotNull(delegate, "delegate"));
        this.filter = MuxServerSocketChannel.assertIsNotNull(filter, "filter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SocketChannel accept() throws IOException {
        while (true) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isBound()) {
                throw new NotYetBoundException();
            }
            Object object = this.syncRoot;
            synchronized (object) {
                SocketChannel accepted = this.acceptQ.poll();
                if (accepted == null) {
                    if (!this.isBlocking()) return accepted;
                    try {
                        this.syncRoot.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else if (accepted.isOpen() && (accepted = this.implAccept(accepted)) != null) {
                    return accepted;
                }
            }
        }
    }

    protected boolean filterAccept(DatagramPacket p, SocketChannel channel) {
        boolean b = this.filter.accept(p) ? this.qAccept(new PreReadSocketChannel(p, channel)) : false;
        return b;
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        if (!block) {
            ((MuxingServerSocketChannel)this.delegate).configureBlocking(block);
        }
    }

    @Override
    protected MuxServerSocket implSocket(ServerSocket socket) throws IOException {
        return new MuxServerSocket((MuxingServerSocket)socket, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean qAccept(SocketChannel channel) {
        boolean b;
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.acceptQ.offer(channel)) {
                this.syncRoot.notifyAll();
                b = true;
            } else {
                b = false;
            }
        }
        return b;
    }

    public static class MuxServerSocket
    extends DelegatingServerSocket {
        public MuxServerSocket(MuxingServerSocket delegate, MuxServerSocketChannel channel) throws IOException {
            super(MuxServerSocketChannel.assertIsNotNull(delegate, "delegate"), MuxServerSocketChannel.assertIsNotNull(channel, "channel"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MuxingServerSocketChannel
    extends DelegatingServerSocketChannel<ServerSocketChannel> {
        private static Selector acceptSelector;
        private static Thread acceptThread;
        private static final List<MuxingServerSocketChannel> muxingServerSocketChannels;
        private final List<MuxServerSocketChannel> muxServerSocketChannels = new ArrayList<MuxServerSocketChannel>();
        private final Queue<SocketChannel> readQ = new LinkedList<SocketChannel>();
        private final Selector readSelector;
        private Thread readThread;
        private final Object syncRoot = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void addMuxingServerSocketChannel(MuxingServerSocketChannel channel) throws IOException {
            List<MuxingServerSocketChannel> list = muxingServerSocketChannels;
            synchronized (list) {
                muxingServerSocketChannels.add(channel);
                muxingServerSocketChannels.notifyAll();
                MuxingServerSocketChannel.scheduleAccept(channel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MuxingServerSocketChannel findMuxingServerSocketChannel(SocketAddress localAddr) {
            MuxingServerSocketChannel channel = null;
            List<MuxingServerSocketChannel> list = muxingServerSocketChannels;
            synchronized (list) {
                Iterator<MuxingServerSocketChannel> i = muxingServerSocketChannels.iterator();
                while (i.hasNext()) {
                    MuxingServerSocketChannel aChannel = i.next();
                    if (aChannel.isOpen()) {
                        SocketAddress aLocalAddr;
                        try {
                            aLocalAddr = aChannel.getLocalAddress();
                        }
                        catch (ClosedChannelException cce) {
                            i.remove();
                            aLocalAddr = null;
                        }
                        catch (IOException ioe) {
                            aLocalAddr = null;
                        }
                        if (aLocalAddr == null || !aLocalAddr.equals(localAddr)) continue;
                        channel = aChannel;
                        break;
                    }
                    i.remove();
                }
            }
            return channel;
        }

        private static void maybeCloseAcceptSelector() {
            if (acceptSelector != null) {
                if (acceptSelector.isOpen()) {
                    try {
                        acceptSelector.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                acceptSelector = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static MuxServerSocketChannel openAndBind(Map<String, Object> properties, SocketAddress endpoint, int backlog, DatagramPacketFilter filter) throws IOException {
            MuxingServerSocketChannel muxingChannel;
            MuxServerSocketChannel.assertIsNotNull(filter, "filter");
            List<MuxingServerSocketChannel> list = muxingServerSocketChannels;
            synchronized (list) {
                muxingChannel = MuxingServerSocketChannel.findMuxingServerSocketChannel(endpoint);
                if (muxingChannel == null) {
                    ServerSocketChannel channel = ServerSocketChannel.open();
                    ServerSocket socket = channel.socket();
                    if (properties != null && !properties.isEmpty()) {
                        for (Map.Entry<String, Object> property : properties.entrySet()) {
                            String name = property.getKey();
                            if (!MuxServerSocketChannel.SOCKET_REUSE_ADDRESS_PROPERTY_NAME.equals(name)) continue;
                            Object value = property.getValue();
                            boolean on = value == null ? false : (value instanceof Boolean ? ((Boolean)value).booleanValue() : Boolean.valueOf(value.toString()).booleanValue());
                            socket.setReuseAddress(on);
                        }
                    }
                    socket.bind(endpoint, backlog);
                    muxingChannel = new MuxingServerSocketChannel(channel);
                    MuxingServerSocketChannel.addMuxingServerSocketChannel(muxingChannel);
                }
            }
            return muxingChannel.createMuxServerSocketChannel(filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void runInAcceptThread() {
            while (true) {
                Selector sel;
                boolean select = false;
                List<MuxingServerSocketChannel> list = muxingServerSocketChannels;
                synchronized (list) {
                    if (!Thread.currentThread().equals(acceptThread)) {
                        break;
                    }
                    sel = acceptSelector;
                    if (!sel.isOpen()) {
                        break;
                    }
                    Iterator<MuxingServerSocketChannel> i = muxingServerSocketChannels.iterator();
                    while (i.hasNext()) {
                        MuxingServerSocketChannel ch = i.next();
                        if (ch.isOpen()) {
                            try {
                                ch.accept();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (ch.isOpen() && ch.keyFor(sel) == null) {
                                try {
                                    ch.register(sel, 16);
                                }
                                catch (ClosedChannelException closedChannelException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (ch.isOpen()) {
                            select = true;
                            continue;
                        }
                        i.remove();
                    }
                    sel.selectedKeys().clear();
                    if (!select) {
                        try {
                            muxingServerSocketChannels.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (!select) continue;
                try {
                    sel.select();
                    continue;
                }
                catch (ClosedSelectorException cse) {
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void scheduleAccept(MuxingServerSocketChannel channel) throws IOException {
            List<MuxingServerSocketChannel> list = muxingServerSocketChannels;
            synchronized (list) {
                if (acceptThread == null) {
                    MuxingServerSocketChannel.maybeCloseAcceptSelector();
                    try {
                        acceptSelector = channel.provider().openSelector();
                    }
                    catch (IOException ioe) {
                        acceptSelector = Selector.open();
                    }
                    acceptThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                MuxingServerSocketChannel.runInAcceptThread();
                            }
                            finally {
                                List list = muxingServerSocketChannels;
                                synchronized (list) {
                                    if (Thread.currentThread().equals(acceptThread)) {
                                        acceptThread = null;
                                        MuxingServerSocketChannel.maybeCloseAcceptSelector();
                                    }
                                }
                            }
                        }
                    };
                    acceptThread.setDaemon(true);
                    acceptThread.setName(MuxingServerSocketChannel.class.getName() + ".acceptThread");
                    acceptThread.start();
                } else {
                    Selector sel = acceptSelector;
                    if (sel != null) {
                        sel.wakeup();
                    }
                }
            }
            channel.accept();
        }

        public MuxingServerSocketChannel(ServerSocketChannel delegate) throws IOException {
            super(MuxServerSocketChannel.assertIsNotNull(delegate, "delegate"));
            this.configureBlocking(false);
            this.readSelector = this.provider().openSelector();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addMuxServerSocketChannel(MuxServerSocketChannel channel) {
            Object object = this.syncRoot;
            synchronized (object) {
                this.muxServerSocketChannels.add(channel);
                this.syncRoot.notifyAll();
                this.scheduleRead(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected MuxServerSocketChannel createMuxServerSocketChannel(DatagramPacketFilter filter) {
            MuxServerSocketChannel channel;
            MuxServerSocketChannel.assertIsNotNull(filter, "filter");
            Object object = this.syncRoot;
            synchronized (object) {
                Iterator<MuxServerSocketChannel> i = this.muxServerSocketChannels.iterator();
                while (i.hasNext()) {
                    MuxServerSocketChannel aChannel = i.next();
                    if (aChannel.isOpen()) {
                        DatagramPacketFilter aFilter = aChannel.filter;
                        if (!filter.equals(aFilter) && !aFilter.equals(filter)) continue;
                        throw new IllegalArgumentException("filter");
                    }
                    i.remove();
                }
                channel = new MuxServerSocketChannel(this, filter);
                this.addMuxServerSocketChannel(channel);
            }
            this.muxServerSocketChannelAdded(channel);
            return channel;
        }

        private boolean filterAccept(DatagramPacket p, SocketChannel channel) {
            boolean b = false;
            Iterator<MuxServerSocketChannel> i = this.muxServerSocketChannels.iterator();
            while (i.hasNext()) {
                MuxServerSocketChannel muxChannel = i.next();
                if (muxChannel.isOpen()) {
                    try {
                        b = muxChannel.filterAccept(p, channel);
                        if (!b) continue;
                        break;
                    }
                    catch (Throwable t) {
                        if (t instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        if (!(t instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)t;
                    }
                }
                i.remove();
            }
            return b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected SocketChannel implAccept(SocketChannel accepted) throws IOException {
            Object object = this.syncRoot;
            synchronized (object) {
                if (accepted != null && accepted.isOpen()) {
                    accepted.configureBlocking(false);
                    this.readQ.add(accepted);
                    this.syncRoot.notifyAll();
                    this.scheduleRead(accepted);
                }
            }
            return accepted;
        }

        @Override
        protected MuxingServerSocket implSocket(ServerSocket socket) throws IOException {
            return new MuxingServerSocket(socket, this);
        }

        protected int maybeRead(SocketChannel channel, ByteBuffer buf) {
            int read;
            if (buf.remaining() > 0) {
                try {
                    read = channel.read(buf);
                }
                catch (IOException ioe) {
                    read = 0;
                }
            } else {
                read = 0;
            }
            return read;
        }

        protected void muxServerSocketChannelAdded(MuxServerSocketChannel channel) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runInReadThread() {
            while (true) {
                Selector sel;
                boolean select = false;
                Object object = this.syncRoot;
                synchronized (object) {
                    if (!Thread.currentThread().equals(this.readThread)) {
                        break;
                    }
                    sel = this.readSelector;
                    if (!sel.isOpen()) {
                        break;
                    }
                    Iterator i = this.readQ.iterator();
                    while (i.hasNext()) {
                        SocketChannel ch = (SocketChannel)i.next();
                        boolean remove = false;
                        if (ch.isOpen()) {
                            SelectionKey sk = ch.keyFor(sel);
                            if (sk == null) {
                                try {
                                    sk = ch.register(sel, 1);
                                }
                                catch (ClosedChannelException closedChannelException) {
                                    // empty catch block
                                }
                            }
                            if (sk != null && sk.isValid()) {
                                DatagramBuffer db = (DatagramBuffer)sk.attachment();
                                if (db == null) {
                                    db = new DatagramBuffer(SOCKET_CHANNEL_READ_CAPACITY);
                                    sk.attach(db);
                                }
                                int read = this.maybeRead(ch, db.getByteBuffer());
                                if (ch.isOpen()) {
                                    DatagramPacket pkt;
                                    long now = System.currentTimeMillis();
                                    if (read > 0 || db.timestamp == -1L) {
                                        db.timestamp = now;
                                    }
                                    if ((pkt = db.getDatagramPacket()).getLength() > 0 && this.filterAccept(pkt, ch)) {
                                        sk.cancel();
                                        remove = true;
                                    } else if (read <= 0 && now - db.timestamp > 15000L) {
                                        MuxServerSocketChannel.closeNoExceptions(ch);
                                    }
                                }
                            }
                        }
                        if (remove || !ch.isOpen()) {
                            i.remove();
                            continue;
                        }
                        select = true;
                    }
                    sel.selectedKeys().clear();
                    if (!select) {
                        try {
                            this.syncRoot.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (!select) continue;
                try {
                    sel.select();
                    continue;
                }
                catch (ClosedSelectorException cse) {
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void scheduleRead(SocketChannel channel) {
            Object object = this.syncRoot;
            synchronized (object) {
                if (this.readThread == null) {
                    this.readThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                MuxingServerSocketChannel.this.runInReadThread();
                            }
                            finally {
                                Object object = MuxingServerSocketChannel.this.syncRoot;
                                synchronized (object) {
                                    if (Thread.currentThread().equals(MuxingServerSocketChannel.this.readThread)) {
                                        MuxingServerSocketChannel.this.readThread = null;
                                    }
                                }
                            }
                        }
                    };
                    this.readThread.setDaemon(true);
                    this.readThread.setName(MuxingServerSocketChannel.class.getName() + ".readThread");
                    this.readThread.start();
                } else {
                    Selector sel = this.readSelector;
                    if (sel != null) {
                        sel.wakeup();
                    }
                }
            }
        }

        static {
            muxingServerSocketChannels = new LinkedList<MuxingServerSocketChannel>();
        }
    }

    protected static class MuxingServerSocket
    extends DelegatingServerSocket {
        public MuxingServerSocket(ServerSocket delegate, MuxingServerSocketChannel channel) throws IOException {
            super(MuxServerSocketChannel.assertIsNotNull(delegate, "delegate"), MuxServerSocketChannel.assertIsNotNull(channel, "channel"));
        }
    }

    private static class DatagramBuffer {
        private final ByteBuffer byteBuffer;
        private final DatagramPacket datagramPacket;
        long timestamp = -1L;

        public DatagramBuffer(int capacity) {
            this.byteBuffer = ByteBuffer.allocate(capacity);
            this.datagramPacket = new DatagramPacket(this.byteBuffer.array(), 0, 0);
        }

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        public DatagramPacket getDatagramPacket() {
            this.datagramPacket.setLength(this.byteBuffer.position());
            return this.datagramPacket;
        }
    }
}

