/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Set;
import org.ice4j.socket.DelegatingServerSocket;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingServerSocketChannel<T extends ServerSocketChannel>
extends ServerSocketChannel
implements SelChImpl {
    protected final T delegate;
    protected final SelChImpl delegateAsSelChImpl;
    private ServerSocket socket;
    private final Object socketSyncRoot = new Object();

    public DelegatingServerSocketChannel(T delegate) {
        super(((AbstractSelectableChannel)delegate).provider());
        this.delegate = delegate;
        this.delegateAsSelChImpl = delegate instanceof SelChImpl ? (SelChImpl)delegate : null;
    }

    @Override
    public SocketChannel accept() throws IOException {
        SocketChannel channel = ((ServerSocketChannel)this.delegate).accept();
        return channel == null ? null : this.implAccept(channel);
    }

    @Override
    public ServerSocketChannel bind(SocketAddress local, int backlog) throws IOException {
        ((ServerSocketChannel)this.delegate).bind(local, backlog);
        return this;
    }

    @Override
    public FileDescriptor getFD() {
        return this.delegateAsSelChImpl.getFD();
    }

    @Override
    public int getFDVal() {
        return this.delegateAsSelChImpl.getFDVal();
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return ((ServerSocketChannel)this.delegate).getLocalAddress();
    }

    public <U> U getOption(SocketOption<U> name) throws IOException {
        return this.delegate.getOption(name);
    }

    protected SocketChannel implAccept(SocketChannel accepted) throws IOException {
        return accepted;
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        ((AbstractInterruptibleChannel)this.delegate).close();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        ((AbstractSelectableChannel)this.delegate).configureBlocking(block);
    }

    protected ServerSocket implSocket(ServerSocket socket) throws IOException {
        return new DelegatingServerSocket(socket, this);
    }

    public boolean isBound() {
        try {
            return this.getLocalAddress() != null;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public void kill() throws IOException {
        this.delegateAsSelChImpl.kill();
    }

    public <U> ServerSocketChannel setOption(SocketOption<U> name, U value) throws IOException {
        ((ServerSocketChannel)this.delegate).setOption((SocketOption)name, value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerSocket socket() {
        ServerSocket socket = ((ServerSocketChannel)this.delegate).socket();
        Object object = this.socketSyncRoot;
        synchronized (object) {
            if (this.socket == null) {
                if (socket != null) {
                    try {
                        this.socket = this.implSocket(socket);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            } else if (socket == null) {
                this.socket = null;
            }
            return this.socket;
        }
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.delegate.supportedOptions();
    }

    public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
        this.delegateAsSelChImpl.translateAndSetInterestOps(ops, sk);
    }

    @Override
    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl sk) {
        return this.delegateAsSelChImpl.translateAndSetReadyOps(ops, sk);
    }

    @Override
    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl sk) {
        return this.delegateAsSelChImpl.translateAndUpdateReadyOps(ops, sk);
    }
}

