/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.in;

import java.util.StringTokenizer;
import pl.mn.communicator.Gender;
import pl.mn.communicator.PersonalInfo;
import pl.mn.communicator.PublicDirSearchReply;
import pl.mn.communicator.RemoteStatus;
import pl.mn.communicator.packet.GGConversion;
import pl.mn.communicator.packet.GGPubdirConsts;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.in.GGIncomingPackage;

public class GGPubdirReply
implements GGIncomingPackage,
GGPubdirConsts {
    public static final int GG_PUBDIR50_REPLY = 14;
    private byte m_replyType = (byte)-1;
    private int m_querySeq = -1;
    private PersonalInfo m_pubDirInfo = null;
    private PublicDirSearchReply m_publicDirSearchReply = null;

    public GGPubdirReply(byte[] data) {
        this.m_replyType = data[0];
        this.m_querySeq = GGUtils.byteToInt(data, 1);
        if (this.isPubdirReadReply()) {
            this.handlePubdirReadReply(data);
        } else if (this.isPubdirSearchReply()) {
            this.handlePubdirSearchReply(data);
        }
    }

    public int getQuerySeq() {
        return this.m_querySeq;
    }

    public PersonalInfo getPubdirReadReply() {
        return this.m_pubDirInfo;
    }

    public PublicDirSearchReply getPubdirSearchReply() {
        return this.m_publicDirSearchReply;
    }

    public int getPacketType() {
        return 14;
    }

    public boolean isPubdirSearchReply() {
        return this.m_replyType == 5;
    }

    public boolean isPubdirReadReply() {
        return this.m_replyType == 3;
    }

    public boolean isPubdirWriteReply() {
        return this.m_replyType == 1;
    }

    private void handlePubdirReadReply(byte[] data) {
        String string = GGUtils.byteToString(data, 5);
        StringTokenizer tokenizer = new StringTokenizer(string, "\u0000");
        this.m_pubDirInfo = new PersonalInfo();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("firstname")) {
                String firstName = tokenizer.nextToken();
                this.m_pubDirInfo.setFirstName(firstName);
                continue;
            }
            if (token.equals("lastname")) {
                String lastName = tokenizer.nextToken();
                this.m_pubDirInfo.setLastName(lastName);
                continue;
            }
            if (token.equals("birthyear")) {
                String birthDate = tokenizer.nextToken();
                this.m_pubDirInfo.setBirthDate(birthDate);
                continue;
            }
            if (token.equals("city")) {
                String city = tokenizer.nextToken();
                this.m_pubDirInfo.setCity(city);
                continue;
            }
            if (token.equals("nickname")) {
                String nickName = tokenizer.nextToken();
                this.m_pubDirInfo.setNickName(nickName);
                continue;
            }
            if (token.equals("gender")) {
                String genderString = tokenizer.nextToken();
                Gender gender = null;
                if (genderString.equals("1")) {
                    gender = Gender.MALE;
                } else if (genderString.equals("2")) {
                    gender = Gender.FEMALE;
                }
                this.m_pubDirInfo.setGender(gender);
                continue;
            }
            if (token.equals("familyname")) {
                String familyName = tokenizer.nextToken();
                this.m_pubDirInfo.setFamilyName(familyName);
                continue;
            }
            if (!token.equals("familycity")) continue;
            String familyCity = tokenizer.nextToken();
            this.m_pubDirInfo.setFamilyCity(familyCity);
        }
    }

    private void handlePubdirSearchReply(byte[] data) {
        String string = GGUtils.byteToString(data, 5);
        this.m_publicDirSearchReply = new PublicDirSearchReply();
        StringTokenizer tokenizer = new StringTokenizer(string, "\u0000");
        PublicDirSearchReply.Entry entry = this.m_publicDirSearchReply.createSearchEntry();
        boolean processedUin = false;
        while (tokenizer.hasMoreTokens()) {
            String uin;
            String token = tokenizer.nextToken();
            if (processedUin && token.equals("FmNumber")) {
                processedUin = false;
                entry = this.m_publicDirSearchReply.createSearchEntry();
                uin = tokenizer.nextToken();
                entry.setUin(Integer.valueOf(uin));
                processedUin = true;
                continue;
            }
            if (token.equals("firstname")) {
                String firstName = tokenizer.nextToken();
                entry.setFirstName(firstName);
                continue;
            }
            if (token.equals("FmNumber")) {
                uin = tokenizer.nextToken();
                entry.setUin(Integer.valueOf(uin));
                processedUin = true;
                continue;
            }
            if (token.equals("FmStatus")) {
                String status = tokenizer.nextToken();
                int protocolStatus = Integer.valueOf(status);
                RemoteStatus statusBiz = GGConversion.getClientRemoteStatus(protocolStatus, null, -1L);
                entry.setStatus(statusBiz);
                continue;
            }
            if (token.equals("birthyear")) {
                String birthYear = tokenizer.nextToken();
                entry.setBirthYear(birthYear);
                continue;
            }
            if (token.equals("city")) {
                String city = tokenizer.nextToken();
                entry.setCity(city);
                continue;
            }
            if (token.equals("nickname")) {
                String nickName = tokenizer.nextToken();
                entry.setNickName(nickName);
                continue;
            }
            if (!token.equals("nextstart")) continue;
            String nextNumber = tokenizer.nextToken();
            this.m_publicDirSearchReply.setNextStart(Integer.valueOf(nextNumber));
            break;
        }
    }
}

