/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class SsiRightsCmd
extends SsiCommand {
    private static final int TYPE_MAXIMA = 4;
    private final int[] maxima;

    protected SsiRightsCmd(SnacPacket packet) {
        super(3);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        ImmutableTlvChain chain = TlvTools.readChain(snacData);
        Tlv maximaTlv = chain.getLastTlv(4);
        if (maximaTlv != null) {
            ByteBlock block = maximaTlv.getData();
            this.maxima = new int[block.getLength() / 2];
            for (int i = 0; i < this.maxima.length; ++i) {
                this.maxima[i] = BinaryTools.getUShort((ByteBlock)block, (int)(i * 2));
            }
        } else {
            this.maxima = null;
        }
    }

    public SsiRightsCmd(int[] maxima) {
        super(3);
        this.maxima = maxima == null ? null : (int[])maxima.clone();
    }

    public final int[] getMaxima() {
        return this.maxima == null ? null : (int[])this.maxima.clone();
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.maxima != null) {
            ByteArrayOutputStream maximout = new ByteArrayOutputStream();
            try {
                for (int aMaxima : this.maxima) {
                    BinaryTools.writeUShort((OutputStream)maximout, (int)aMaxima);
                }
            }
            catch (IOException impossible) {
                // empty catch block
            }
            ByteBlock maximaBlock = ByteBlock.wrap((byte[])maximout.toByteArray());
            new Tlv(4, (Writable)maximaBlock).write(out);
        }
    }

    public String toString() {
        StringBuffer buffer = null;
        if (this.maxima != null) {
            buffer = new StringBuffer(this.maxima.length * 12);
            for (int i = 0; i < this.maxima.length; ++i) {
                buffer.append("0x");
                buffer.append(Integer.toHexString(i));
                buffer.append(": ");
                buffer.append(this.maxima[i]);
                buffer.append(", ");
            }
        }
        return "SsiRightsCmd: maxima: " + buffer;
    }
}

