/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.commands.MessageCommand;
import f00f.net.irc.martyr.util.FullNick;
import java.util.StringTokenizer;

public class CtcpMessage
extends MessageCommand {
    private String actionStr;

    public CtcpMessage(String dest, String message) {
        super(dest, "\u0001" + message + "\u0001");
    }

    public CtcpMessage(String dest, String action, String message) {
        this(dest, action + " " + message);
    }

    protected CtcpMessage(FullNick from, String dest, String message) {
        super(from, dest, CtcpMessage.getMessageStr(CtcpMessage.stripCtcpWrapper(message)));
        this.actionStr = CtcpMessage.getActionStr(CtcpMessage.stripCtcpWrapper(message));
    }

    public String getAction() {
        return this.actionStr;
    }

    public static String getActionStr(String msg) {
        StringTokenizer tokens = new StringTokenizer(msg);
        return tokens.nextToken();
    }

    public static String getMessageStr(String msg) {
        String acn = CtcpMessage.getActionStr(msg);
        return msg.substring(acn.length()).trim();
    }

    public static boolean isCtcpString(String msg) {
        return msg.charAt(0) == '\u0001' && msg.charAt(msg.length() - 1) == '\u0001';
    }

    public static String stripCtcpWrapper(String msg) {
        if (CtcpMessage.isCtcpString(msg)) {
            return msg.substring(1, msg.length() - 1);
        }
        return msg;
    }
}

