/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.UnresolvedAddressException;
import net.sf.jqql.net.AbstractPort;
import net.sf.jqql.net.IConnectionPolicy;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08InPacket;
import net.sf.jqql.packets._08OutPacket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPPort
extends AbstractPort {
    private static final Log log = LogFactory.getLog(UDPPort.class);
    protected final DatagramChannel channel = DatagramChannel.open();

    public UDPPort(IConnectionPolicy iConnectionPolicy, InetSocketAddress inetSocketAddress) throws IOException {
        super(iConnectionPolicy);
        this.channel.configureBlocking(false);
        this.remoteAddress = inetSocketAddress;
    }

    public SelectableChannel channel() {
        return this.channel;
    }

    public void start() {
        try {
            this.channel.connect(this.remoteAddress);
        }
        catch (UnknownHostException unknownHostException) {
            log.error((Object)"Unknown host for connection.");
            this.processError(new Exception("Unknown Host"));
        }
        catch (UnresolvedAddressException unresolvedAddressException) {
            log.error((Object)"Unresolvable address for connection.");
            this.processError(new Exception("Unable to resolve server address"));
        }
        catch (IOException iOException) {
            log.error((Object)"IO error while trying to connect.");
            this.processError(iOException);
        }
    }

    public void receive() throws IOException, PacketParseException {
        this.receiveBuf.clear();
        int n = this.channel.read(this.receiveBuf);
        while (n > 0) {
            this.receiveBuf.flip();
            _08InPacket _08InPacket2 = this.policy.parseIn(this.receiveBuf, false);
            if (_08InPacket2 != null) {
                this.policy.pushIn(_08InPacket2);
            }
            this.receiveBuf.clear();
            n = this.channel.read(this.receiveBuf);
        }
    }

    public void send() throws IOException {
        while (!this.isEmpty()) {
            this.sendBuf.clear();
            _08OutPacket _08OutPacket2 = this.remove();
            _08OutPacket2.fill(this.sendBuf);
            this.sendBuf.flip();
            if (_08OutPacket2.needAck()) {
                this.channel.write(this.sendBuf);
                _08OutPacket2.setTimeout(System.currentTimeMillis() + 5000L);
                this.policy.pushResend(_08OutPacket2, this.getId());
                log.debug((Object)("Sent - " + _08OutPacket2.toString()));
                continue;
            }
            int n = _08OutPacket2.getSendCount();
            for (int i = 0; i < n; ++i) {
                this.sendBuf.rewind();
                this.channel.write(this.sendBuf);
                log.debug((Object)("Sent - " + _08OutPacket2.toString()));
            }
        }
    }

    public void send(_08OutPacket _08OutPacket2) {
        try {
            this.sendBuf.clear();
            _08OutPacket2.fill(this.sendBuf);
            this.sendBuf.flip();
            if (_08OutPacket2.needAck()) {
                this.channel.write(this.sendBuf);
                log.debug((Object)("Sent - " + _08OutPacket2.toString()));
            } else {
                int n = _08OutPacket2.getSendCount();
                for (int i = 0; i < n; ++i) {
                    this.sendBuf.rewind();
                    this.channel.write(this.sendBuf);
                    log.debug((Object)("Sent - " + _08OutPacket2.toString()));
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage());
        }
    }

    public void send(ByteBuffer byteBuffer) {
        try {
            this.channel.write(byteBuffer);
        }
        catch (IOException iOException) {
            log.error((Object)iOException.getMessage());
        }
    }

    public void dispose() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return true;
    }

    public void processConnect(SelectionKey selectionKey) throws IOException {
    }

    public void processRead(SelectionKey selectionKey) throws IOException, PacketParseException {
        this.receive();
    }

    public void processWrite() throws IOException {
        this.send();
    }
}

