/*
 * Decompiled with CFR 0.152.
 */
package org.openymsg.network;

import java.util.Properties;
import org.openymsg.network.DirectConnectionHandler;

public class SOCKSConnectionHandler
extends DirectConnectionHandler {
    private String socksHost;
    private int socksPort;

    public SOCKSConnectionHandler() throws IllegalArgumentException {
        this.socksHost = System.getProperty("socksProxyHost", "");
        this.socksPort = Integer.parseInt(System.getProperty("socksProxyPort", "-1"));
        if (this.socksHost.length() <= 0 || this.socksPort <= 0) {
            throw new IllegalArgumentException("Bad SOCKS proxy properties: " + this.socksHost + ":" + this.socksPort);
        }
        System.getProperties().put("socksProxySet", "true");
    }

    public SOCKSConnectionHandler(String h, int p) {
        this.socksHost = h;
        this.socksPort = p;
        Properties pr = System.getProperties();
        pr.put("socksProxyHost", this.socksHost);
        pr.put("socksProxyPort", this.socksPort + "");
        pr.put("socksProxySet", "true");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SOCKS connection: ").append(this.socksHost).append(":").append(this.socksPort);
        return sb.toString();
    }
}

