/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.AbstractXmlWriter;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;
import org.jdom.JDOMFactory;

public class JDomWriter
extends AbstractXmlWriter {
    private List result = new LinkedList();
    private List elementStack = new LinkedList();
    private final JDOMFactory documentFactory;

    public JDomWriter(Element container, JDOMFactory factory, XmlFriendlyReplacer replacer) {
        super(replacer);
        this.elementStack.add(0, container);
        this.result.add(container);
        this.documentFactory = factory;
    }

    public JDomWriter(Element container, JDOMFactory factory) {
        this(container, factory, new XmlFriendlyReplacer());
    }

    public JDomWriter(JDOMFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

    public JDomWriter(Element container) {
        this(container, (JDOMFactory)new DefaultJDOMFactory());
    }

    public JDomWriter() {
        this((JDOMFactory)new DefaultJDOMFactory());
    }

    public void startNode(String name) {
        Element element = this.documentFactory.element(this.escapeXmlName(name));
        Element parent = this.top();
        if (parent != null) {
            parent.addContent((Content)element);
        } else {
            this.result.add(element);
        }
        this.elementStack.add(0, element);
    }

    public void startNode(String name, Class clazz) {
        this.startNode(name);
    }

    public void setValue(String text) {
        this.top().addContent((Content)this.documentFactory.text(text));
    }

    public void addAttribute(String key, String value) {
        this.top().setAttribute(this.documentFactory.attribute(this.escapeXmlName(key), value));
    }

    public void endNode() {
        this.elementStack.remove(0);
    }

    private Element top() {
        Element top = null;
        if (!this.elementStack.isEmpty()) {
            top = (Element)this.elementStack.get(0);
        }
        return top;
    }

    public List getResult() {
        return this.result;
    }

    public void flush() {
    }

    public void close() {
    }

    public HierarchicalStreamWriter underlyingWriter() {
        return this;
    }
}

