/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.tagext.TagInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.JspSourceDependent;

public class JspServletWrapper {
    private Log log = LogFactory.getLog((Class)JspServletWrapper.class);
    private Servlet theServlet;
    private String jspUri;
    private Class servletClass;
    private Class tagHandlerClass;
    private JspCompilationContext ctxt;
    private long available = 0L;
    private ServletConfig config;
    private Options options;
    private boolean firstTime = true;
    private boolean reload = true;
    private boolean isTagFile;
    private int tripCount;
    private JasperException compileException;
    private long servletClassLastModifiedTime;
    private long lastModificationTest = 0L;

    JspServletWrapper(ServletConfig config, Options options, String jspUri, boolean isErrorPage, JspRuntimeContext rctxt) throws JasperException {
        this.isTagFile = false;
        this.config = config;
        this.options = options;
        this.jspUri = jspUri;
        this.ctxt = new JspCompilationContext(jspUri, isErrorPage, options, config.getServletContext(), this, rctxt);
    }

    public JspServletWrapper(ServletContext servletContext, Options options, String tagFilePath, TagInfo tagInfo, JspRuntimeContext rctxt, URL tagFileJarUrl) throws JasperException {
        this.isTagFile = true;
        this.config = null;
        this.options = options;
        this.jspUri = tagFilePath;
        this.tripCount = 0;
        this.ctxt = new JspCompilationContext(this.jspUri, tagInfo, options, servletContext, this, rctxt, tagFileJarUrl);
    }

    public JspCompilationContext getJspEngineContext() {
        return this.ctxt;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet getServlet() throws ServletException, IOException, FileNotFoundException {
        if (this.reload) {
            JspServletWrapper jspServletWrapper = this;
            synchronized (jspServletWrapper) {
                if (this.reload) {
                    this.destroy();
                    try {
                        this.servletClass = this.ctxt.load();
                        this.theServlet = (Servlet)this.servletClass.newInstance();
                    }
                    catch (IllegalAccessException ex1) {
                        throw new JasperException((Throwable)ex1);
                    }
                    catch (InstantiationException ex) {
                        throw new JasperException((Throwable)ex);
                    }
                    this.theServlet.init(this.config);
                    if (!this.firstTime) {
                        this.ctxt.getRuntimeContext().incrementJspReloadCount();
                    }
                    this.reload = false;
                }
            }
        }
        return this.theServlet;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public void setCompilationException(JasperException je) {
        this.compileException = je;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServletClassLastModifiedTime(long lastModified) {
        if (this.servletClassLastModifiedTime < lastModified) {
            JspServletWrapper jspServletWrapper = this;
            synchronized (jspServletWrapper) {
                if (this.servletClassLastModifiedTime < lastModified) {
                    this.servletClassLastModifiedTime = lastModified;
                    this.reload = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadTagFile() throws JasperException {
        try {
            if (this.ctxt.isRemoved()) {
                throw new FileNotFoundException(this.jspUri);
            }
            if (this.options.getDevelopment() || this.firstTime) {
                JspServletWrapper jspServletWrapper = this;
                synchronized (jspServletWrapper) {
                    this.firstTime = false;
                    this.ctxt.compile();
                }
            } else if (this.compileException != null) {
                throw this.compileException;
            }
            if (this.reload) {
                this.tagHandlerClass = this.ctxt.load();
            }
        }
        catch (FileNotFoundException ex) {
            throw new JasperException((Throwable)ex);
        }
        return this.tagHandlerClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadTagFilePrototype() throws JasperException {
        this.ctxt.setPrototypeMode(true);
        try {
            Class clazz = this.loadTagFile();
            return clazz;
        }
        finally {
            this.ctxt.setPrototypeMode(false);
        }
    }

    public List getDependants() {
        try {
            Object target;
            if (this.isTagFile) {
                if (this.reload) {
                    this.tagHandlerClass = this.ctxt.load();
                }
                target = this.tagHandlerClass.newInstance();
            } else {
                target = this.getServlet();
            }
            if (target != null && target instanceof JspSourceDependent) {
                return (List)((JspSourceDependent)target).getDependants();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public boolean isTagFile() {
        return this.isTagFile;
    }

    public int incTripCount() {
        return this.tripCount++;
    }

    public int decTripCount() {
        return this.tripCount--;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response, boolean precompile) throws ServletException, IOException, FileNotFoundException {
        block29: {
            try {
                JspServletWrapper jspServletWrapper;
                if (this.ctxt.isRemoved()) {
                    throw new FileNotFoundException(this.jspUri);
                }
                if (this.available > 0L && this.available < Long.MAX_VALUE) {
                    response.setDateHeader("Retry-After", this.available);
                    response.sendError(503, Localizer.getMessage("jsp.error.unavailable"));
                }
                if (this.options.getDevelopment() || this.firstTime) {
                    jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        this.firstTime = false;
                        this.ctxt.compile();
                    }
                } else if (this.compileException != null) {
                    throw this.compileException;
                }
                this.getServlet();
                if (precompile) {
                    return;
                }
                if (this.theServlet instanceof SingleThreadModel) {
                    jspServletWrapper = this;
                    synchronized (jspServletWrapper) {
                        this.theServlet.service((ServletRequest)request, (ServletResponse)response);
                        break block29;
                    }
                }
                this.theServlet.service((ServletRequest)request, (ServletResponse)response);
            }
            catch (UnavailableException ex) {
                String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                if (includeRequestUri != null) {
                    throw ex;
                }
                int unavailableSeconds = ex.getUnavailableSeconds();
                if (unavailableSeconds <= 0) {
                    unavailableSeconds = 60;
                }
                this.available = System.currentTimeMillis() + (long)unavailableSeconds * 1000L;
                response.sendError(503, ex.getMessage());
            }
            catch (FileNotFoundException ex) {
                this.ctxt.incrementRemoved();
                String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                if (includeRequestUri != null) {
                    throw new ServletException((Throwable)ex);
                }
                try {
                    response.sendError(404, ex.getMessage());
                }
                catch (IllegalStateException ise) {
                    this.log.error((Object)Localizer.getMessage("jsp.error.file.not.found", ex.getMessage()), (Throwable)ex);
                }
            }
            catch (ServletException ex) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException((Exception)((Object)ex));
                }
                throw ex;
            }
            catch (IOException ex) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException(ex);
                }
                throw ex;
            }
            catch (IllegalStateException ex) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException(ex);
                }
                throw ex;
            }
            catch (Exception ex) {
                if (this.options.getDevelopment()) {
                    throw this.handleJspException(ex);
                }
                throw new JasperException((Throwable)ex);
            }
        }
    }

    public void destroy() {
        if (this.theServlet != null) {
            this.theServlet.destroy();
        }
    }

    public long getLastModificationTest() {
        return this.lastModificationTest;
    }

    public void setLastModificationTest(long lastModificationTest) {
        this.lastModificationTest = lastModificationTest;
    }

    protected JasperException handleJspException(Exception ex) {
        try {
            Throwable realException = ex;
            if (ex instanceof ServletException) {
                realException = ((ServletException)((Object)ex)).getRootCause();
            }
            StackTraceElement[] frames = realException.getStackTrace();
            StackTraceElement jspFrame = null;
            for (int i = 0; i < frames.length; ++i) {
                if (!frames[i].getClassName().equals(this.getServlet().getClass().getName())) continue;
                jspFrame = frames[i];
                break;
            }
            if (jspFrame == null) {
                return new JasperException((Throwable)ex);
            }
            int javaLineNumber = jspFrame.getLineNumber();
            JavacErrorDetail detail = ErrorDispatcher.createJavacError(jspFrame.getMethodName(), this.ctxt.getCompiler().getPageNodes(), null, javaLineNumber);
            int jspLineNumber = detail.getJspBeginLineNumber();
            if (jspLineNumber < 1) {
                throw new JasperException((Throwable)ex);
            }
            String[] jspLines = this.readFile(this.ctxt.getResourceAsStream(this.ctxt.getJspFile()));
            String[] javaLines = this.readFile(new FileInputStream(this.ctxt.getServletJavaFileName()));
            if (jspLines[jspLineNumber - 1].lastIndexOf("<%") > jspLines[jspLineNumber - 1].lastIndexOf("%>")) {
                String javaLine = javaLines[javaLineNumber - 1].trim();
                for (int i = jspLineNumber - 1; i < jspLines.length; ++i) {
                    if (jspLines[i].indexOf(javaLine) == -1) continue;
                    jspLineNumber = i + 1;
                    break;
                }
            }
            StringBuffer buffer = new StringBuffer(1024);
            int startIndex = Math.max(0, jspLineNumber - 1 - 3);
            int endIndex = Math.min(jspLines.length - 1, jspLineNumber - 1 + 3);
            for (int i = startIndex; i <= endIndex; ++i) {
                buffer.append(i + 1);
                buffer.append(": ");
                buffer.append(jspLines[i]);
                buffer.append("\n");
            }
            return new JasperException("Exception in JSP: " + detail.getJspFileName() + ":" + jspLineNumber + "\n\n" + buffer + "\n\nStacktrace:", (Throwable)ex);
        }
        catch (Exception je) {
            return new JasperException((Throwable)ex);
        }
    }

    private String[] readFile(InputStream s) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(s));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines.toArray(new String[lines.size()]);
    }
}

