/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.configuration;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

public class PropertyConfigurator {
    private static final Log LOG = LogFactory.getLog((Class)PropertyConfigurator.class);
    protected static final String PREFIX = "jdbc";
    private static final String DOT = ".";
    private static final String EXAMPLE_FORMAT = "jdbc*.*";

    public static void configure(String filename) throws ProxoolException {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(filename));
        }
        catch (IOException e) {
            throw new ProxoolException("Couldn't load property file " + filename);
        }
        PropertyConfigurator.configure(properties);
    }

    public static void configure(Properties properties) throws ProxoolException {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        Iterator<Object> allPropertyKeysIterator = properties.keySet().iterator();
        Properties proxoolProperties = null;
        while (allPropertyKeysIterator.hasNext()) {
            String key = (String)allPropertyKeysIterator.next();
            String value = properties.getProperty(key);
            if (!key.startsWith(PREFIX)) continue;
            int a = key.indexOf(DOT);
            if (a == -1) {
                throw new ProxoolException("Property " + key + " must be of the format " + EXAMPLE_FORMAT);
            }
            String tag = key.substring(0, a);
            String name = key.substring(a + 1);
            proxoolProperties = (Properties)propertiesMap.get(tag);
            if (proxoolProperties == null) {
                proxoolProperties = new Properties();
                propertiesMap.put(tag, proxoolProperties);
            }
            proxoolProperties.put(name, value);
        }
        Iterator tags = propertiesMap.keySet().iterator();
        while (tags.hasNext()) {
            proxoolProperties = (Properties)propertiesMap.get(tags.next());
            String driverClass = proxoolProperties.getProperty("proxool.driver-class");
            String driverUrl = proxoolProperties.getProperty("proxool.driver-url");
            if (driverClass == null || driverUrl == null) {
                throw new ProxoolException("You must define the proxool.driver-class and the proxool.driver-url.");
            }
            String alias = proxoolProperties.getProperty("proxool.alias");
            StringBuffer url = new StringBuffer();
            url.append("proxool");
            if (alias != null) {
                url.append(DOT);
                url.append(alias);
                proxoolProperties.remove("proxool.alias");
            }
            url.append(":");
            url.append(driverClass);
            proxoolProperties.remove("proxool.driver-class");
            url.append(":");
            url.append(driverUrl);
            proxoolProperties.remove("proxool.driver-url");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created url: " + url));
            }
            ProxoolFacade.registerConnectionPool(url.toString(), proxoolProperties);
        }
    }
}

