/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPObject;

public final class StatusLine
extends SIPObject {
    protected boolean matchStatusClass;
    protected String sipVersion = "SIP/2.0";
    protected int statusCode;
    protected String reasonPhrase = null;

    public boolean match(Object matchObj) {
        if (!(matchObj instanceof StatusLine)) {
            return false;
        }
        StatusLine sl = (StatusLine)matchObj;
        if (sl.matchExpression != null) {
            return sl.matchExpression.match(this.encode());
        }
        if (sl.sipVersion != null && !sl.sipVersion.equals(this.sipVersion)) {
            return false;
        }
        if (sl.statusCode != 0) {
            if (this.matchStatusClass) {
                int hiscode = sl.statusCode;
                String codeString = new Integer(sl.statusCode).toString();
                String mycode = new Integer(this.statusCode).toString();
                if (codeString.charAt(0) != mycode.charAt(0)) {
                    return false;
                }
            } else if (this.statusCode != sl.statusCode) {
                return false;
            }
        }
        if (sl.reasonPhrase == null || this.reasonPhrase == sl.reasonPhrase) {
            return true;
        }
        return this.reasonPhrase.equals(sl.reasonPhrase);
    }

    public void setMatchStatusClass(boolean flag) {
        this.matchStatusClass = flag;
    }

    public String encode() {
        String encoding = "SIP/2.0 " + this.statusCode;
        if (this.reasonPhrase != null) {
            encoding = encoding + " " + this.reasonPhrase;
        }
        encoding = encoding + "\r\n";
        return encoding;
    }

    public String getSipVersion() {
        return this.sipVersion;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public void setSipVersion(String s) {
        this.sipVersion = s;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    public String getVersionMajor() {
        if (this.sipVersion == null) {
            return null;
        }
        String major = null;
        boolean slash = false;
        for (int i = 0; i < this.sipVersion.length(); ++i) {
            if (this.sipVersion.charAt(i) == '.') {
                slash = false;
            }
            if (slash) {
                major = major == null ? "" + this.sipVersion.charAt(i) : major + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) != '/') continue;
            slash = true;
        }
        return major;
    }

    public String getVersionMinor() {
        if (this.sipVersion == null) {
            return null;
        }
        String minor = null;
        boolean dot = false;
        for (int i = 0; i < this.sipVersion.length(); ++i) {
            if (dot) {
                minor = minor == null ? "" + this.sipVersion.charAt(i) : minor + this.sipVersion.charAt(i);
            }
            if (this.sipVersion.charAt(i) != '.') continue;
            dot = true;
        }
        return minor;
    }
}

