/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.nio.AbstractNioChannelSink;
import org.jboss.netty.channel.socket.nio.NioDatagramChannel;
import org.jboss.netty.channel.socket.nio.NioDatagramWorker;
import org.jboss.netty.channel.socket.nio.WorkerPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioDatagramPipelineSink
extends AbstractNioChannelSink {
    private final WorkerPool<NioDatagramWorker> workerPool;

    NioDatagramPipelineSink(WorkerPool<NioDatagramWorker> workerPool) {
        this.workerPool = workerPool;
    }

    @Override
    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        NioDatagramChannel channel = (NioDatagramChannel)e.getChannel();
        ChannelFuture future = e.getFuture();
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent stateEvent = (ChannelStateEvent)e;
            ChannelState state = stateEvent.getState();
            Object value = stateEvent.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        NioDatagramPipelineSink.bind(channel, future, (InetSocketAddress)value);
                        break;
                    }
                    channel.worker.close(channel, future);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        NioDatagramPipelineSink.connect(channel, future, (InetSocketAddress)value);
                        break;
                    }
                    NioDatagramWorker.disconnect(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }

    private static void close(NioDatagramChannel channel, ChannelFuture future) {
        try {
            channel.getDatagramChannel().socket().close();
            if (channel.setClosed()) {
                future.setSuccess();
                if (channel.isBound()) {
                    Channels.fireChannelUnbound(channel);
                }
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void bind(NioDatagramChannel channel, ChannelFuture future, InetSocketAddress address) {
        boolean bound = false;
        boolean started = false;
        try {
            try {
                channel.getDatagramChannel().socket().bind(address);
                bound = true;
                future.setSuccess();
                Channels.fireChannelBound(channel, (SocketAddress)address);
                channel.worker.register(channel, null);
                return;
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var7_6 = null;
                if (started) return;
                if (!bound) return;
                NioDatagramPipelineSink.close(channel, future);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (started || !bound) throw throwable;
            NioDatagramPipelineSink.close(channel, future);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connect(NioDatagramChannel channel, ChannelFuture future, SocketAddress remoteAddress) {
        boolean bound = channel.isBound();
        boolean connected = false;
        boolean workerStarted = false;
        future.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        channel.remoteAddress = null;
        try {
            try {
                channel.getDatagramChannel().connect(remoteAddress);
                connected = true;
                future.setSuccess();
                if (!bound) {
                    Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
                }
                Channels.fireChannelConnected(channel, (SocketAddress)channel.getRemoteAddress());
                if (!bound) {
                    channel.worker.register(channel, future);
                }
                workerStarted = true;
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var8_7 = null;
                if (connected && !workerStarted) {
                    channel.worker.close(channel, future);
                }
            }
            Object var8_6 = null;
            if (connected && !workerStarted) {
                channel.worker.close(channel, future);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (connected && !workerStarted) {
                channel.worker.close(channel, future);
            }
            throw throwable;
        }
    }

    NioDatagramWorker nextWorker() {
        return this.workerPool.nextWorker();
    }
}

