/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.info;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.BuddyInfo;
import net.kano.joustsim.oscar.BuddyInfoManager;
import net.kano.joustsim.oscar.GlobalBuddyInfoAdapter;
import net.kano.joustsim.oscar.oscar.service.info.BuddyHashHolder;
import net.kano.joustsim.oscar.oscar.service.info.BuddyTrustEvent;
import net.kano.joustsim.oscar.oscar.service.info.BuddyTrustListener;
import net.kano.joustsim.oscar.oscar.service.info.CertificateInfoTrustListener;
import net.kano.joustsim.oscar.oscar.service.info.CertificateInfoTrustManager;
import net.kano.joustsim.trust.BuddyCertificateInfo;

public class BuddyTrustManager {
    private static final Logger LOGGER = Logger.getLogger(BuddyTrustManager.class.getName());
    private final BuddyInfoManager buddyInfoManager;
    private final AimConnection conn;
    private final CertificateInfoTrustManager certTrustMgr;
    private Map<Screenname, BuddyTrustInfoHolder> trustInfos = new HashMap<Screenname, BuddyTrustInfoHolder>();
    private Map<Screenname, BuddyCertificateInfo> latestInfos = new HashMap<Screenname, BuddyCertificateInfo>();
    private Map<BuddyHashHolder, BuddyCertificateInfoHolder> cachedCertInfos = new HashMap<BuddyHashHolder, BuddyCertificateInfoHolder>();
    private CopyOnWriteArrayList<BuddyTrustListener> listeners = new CopyOnWriteArrayList();

    public BuddyTrustManager(AimConnection conn) {
        DefensiveTools.checkNull((Object)conn, (String)"conn");
        this.conn = conn;
        this.buddyInfoManager = conn.getBuddyInfoManager();
        this.certTrustMgr = conn.getCertificateInfoTrustManager();
        if (this.buddyInfoManager == null || this.certTrustMgr == null) {
            throw new IllegalArgumentException("conenction has no buddy info manager and/or certificate trust manager");
        }
        this.buddyInfoManager.addGlobalBuddyInfoListener(new GlobalBuddyInfoAdapter(){

            public void buddyInfoChanged(BuddyInfoManager manager, Screenname buddy, BuddyInfo buddyInfo, PropertyChangeEvent event) {
                String prop = event.getPropertyName();
                if (prop.equals("certificateInfo")) {
                    BuddyCertificateInfo certInfo = (BuddyCertificateInfo)event.getNewValue();
                    LOGGER.fine("cert info for " + buddy + " changed: " + certInfo);
                    if (certInfo != null) {
                        BuddyTrustManager.this.cacheCertInfo(certInfo);
                    }
                    BuddyTrustManager.this.handleBuddyHashChange(buddyInfo, certInfo);
                }
            }
        });
        this.certTrustMgr.addTrustListener(new CertificateInfoTrustListener(){

            public void certificateInfoTrusted(CertificateInfoTrustManager manager, BuddyCertificateInfo certInfo) {
                BuddyTrustManager.this.handleCertInfoTrustChange(certInfo, true);
            }

            public void certificateInfoNoLongerTrusted(CertificateInfoTrustManager manager, BuddyCertificateInfo certInfo) {
                BuddyTrustManager.this.handleCertInfoTrustChange(certInfo, false);
            }
        });
    }

    public AimConnection getAimConnection() {
        return this.conn;
    }

    public void addBuddyTrustListener(BuddyTrustListener l) {
        this.listeners.addIfAbsent((Object)l);
    }

    public void removeBuddyTrustListener(BuddyTrustListener l) {
        this.listeners.remove((Object)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCertInfoTrustChange(BuddyCertificateInfo certInfo, boolean trusted) {
        TrustStatus oldTrusted;
        assert (!Thread.holdsLock(this));
        DefensiveTools.checkNull((Object)certInfo, (String)"certInfo");
        TrustStatus newTrusted = trusted ? TrustStatus.TRUSTED : TrustStatus.NOT_TRUSTED;
        Screenname sn = certInfo.getBuddy();
        ByteBlock trustedHash = certInfo.getCertificateInfoHash();
        BuddyTrustManager buddyTrustManager = this;
        synchronized (buddyTrustManager) {
            BuddyCertificateInfo curCertInfo;
            ByteBlock hash;
            BuddyTrustInfoHolder trustHolder = this.getTrustInfoInstance(sn);
            if (trustHolder == null) {
                return;
            }
            BuddyCertificateInfoHolder certInfoHolder = this.getCertificateInfoHolder(sn, trustedHash);
            if (certInfoHolder != null) {
                certInfoHolder.setTrusted(trusted);
            }
            ByteBlock byteBlock = hash = (curCertInfo = this.latestInfos.get(sn)) == null ? null : curCertInfo.getCertificateInfoHash();
            if (hash == null || !hash.equals((Object)trustedHash)) {
                return;
            }
            oldTrusted = trustHolder.getTrustedStatus();
            if (oldTrusted == newTrusted) {
                return;
            }
            trustHolder.setTrustedStatus(newTrusted);
        }
        this.fireChangeEvents(sn, certInfo, oldTrusted, newTrusted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBuddyHashChange(BuddyInfo info, BuddyCertificateInfo certInfo) {
        TrustStatus newStatus;
        TrustStatus oldStatus;
        Screenname sn = info.getScreenname();
        BuddyTrustManager buddyTrustManager = this;
        synchronized (buddyTrustManager) {
            BuddyTrustInfoHolder buddyTrustInfo = this.getTrustInfoInstance(sn);
            oldStatus = buddyTrustInfo.getTrustedStatus();
            LOGGER.info("updating buddy hash for " + sn);
            newStatus = this.updateBuddyHash(sn, certInfo);
            LOGGER.info("new status for " + sn + " is " + newStatus);
            if (newStatus == null) {
                return;
            }
            buddyTrustInfo.setTrustedStatus(newStatus);
        }
        this.fireChangeEvents(sn, certInfo, oldStatus, newStatus);
    }

    private synchronized TrustStatus updateBuddyHash(Screenname sn, BuddyCertificateInfo certInfo) {
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        BuddyCertificateInfo oldInfo = this.latestInfos.put(sn, certInfo);
        if (oldInfo == certInfo || oldInfo != null && oldInfo.equals(certInfo)) {
            return null;
        }
        if (certInfo == null || certInfo.getCertificateInfoHash() == null) {
            return TrustStatus.NOT_TRUSTED;
        }
        if (!certInfo.isUpToDate()) {
            return TrustStatus.UNKNOWN;
        }
        ByteBlock hash = certInfo.getCertificateInfoHash();
        BuddyCertificateInfoHolder certHolder = this.getCertificateInfoHolder(sn, hash);
        if (certHolder == null) {
            return TrustStatus.UNKNOWN;
        }
        if (certHolder.isTrusted()) {
            return TrustStatus.TRUSTED;
        }
        return TrustStatus.NOT_TRUSTED;
    }

    private void fireChangeEvents(Screenname sn, BuddyCertificateInfo certInfo, TrustStatus oldStatus, TrustStatus newStatus) {
        assert (!Thread.holdsLock(this));
        if (newStatus == TrustStatus.UNKNOWN) {
            assert (certInfo == null || !certInfo.isUpToDate());
            this.fireUnknownCertificateChangeEvent(sn, certInfo);
        } else if (newStatus == TrustStatus.NOT_TRUSTED) {
            assert (certInfo == null || certInfo.isUpToDate());
            this.fireUntrustedCertificateChangeEvent(sn, certInfo);
        } else if (newStatus == TrustStatus.TRUSTED) {
            assert (certInfo != null);
            this.fireTrustedCertificateChangeEvent(sn, certInfo);
        }
        if ((oldStatus == TrustStatus.UNKNOWN || oldStatus == TrustStatus.NOT_TRUSTED) && newStatus == TrustStatus.TRUSTED) {
            assert (certInfo != null);
            this.fireBuddyTrustedEvent(sn, certInfo);
        } else if (oldStatus == TrustStatus.TRUSTED && (newStatus == TrustStatus.UNKNOWN || newStatus == TrustStatus.NOT_TRUSTED)) {
            this.fireBuddyNoLongerTrustedEvent(sn, certInfo);
        }
    }

    private void fireTrustedCertificateChangeEvent(Screenname sn, BuddyCertificateInfo certInfo) {
        assert (!Thread.holdsLock(this));
        BuddyTrustEvent event = new BuddyTrustEvent(this, sn, certInfo);
        for (BuddyTrustListener listener : this.listeners) {
            listener.gotTrustedCertificateChange(event);
        }
    }

    private void fireUntrustedCertificateChangeEvent(Screenname sn, BuddyCertificateInfo certInfo) {
        assert (!Thread.holdsLock(this));
        BuddyTrustEvent event = new BuddyTrustEvent(this, sn, certInfo);
        for (BuddyTrustListener listener : this.listeners) {
            listener.gotUntrustedCertificateChange(event);
        }
    }

    private void fireUnknownCertificateChangeEvent(Screenname sn, BuddyCertificateInfo certInfo) {
        assert (!Thread.holdsLock(this));
        BuddyTrustEvent event = new BuddyTrustEvent(this, sn, certInfo);
        for (BuddyTrustListener listener : this.listeners) {
            listener.gotUnknownCertificateChange(event);
        }
    }

    private void fireBuddyTrustedEvent(Screenname sn, BuddyCertificateInfo certInfo) {
        assert (!Thread.holdsLock(this));
        BuddyTrustEvent event = new BuddyTrustEvent(this, sn, certInfo);
        for (BuddyTrustListener listener : this.listeners) {
            listener.buddyTrusted(event);
        }
    }

    private void fireBuddyNoLongerTrustedEvent(Screenname sn, BuddyCertificateInfo certInfo) {
        assert (!Thread.holdsLock(this));
        BuddyTrustEvent event = new BuddyTrustEvent(this, sn, certInfo);
        for (BuddyTrustListener listener : this.listeners) {
            listener.buddyTrustRevoked(event);
        }
    }

    private synchronized BuddyTrustInfoHolder getTrustInfoInstance(Screenname sn) {
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        BuddyTrustInfoHolder inst = this.trustInfos.get(sn);
        if (inst == null) {
            inst = new BuddyTrustInfoHolder(sn);
            this.trustInfos.put(sn, inst);
        }
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheCertInfo(BuddyCertificateInfo certInfo) {
        DefensiveTools.checkNull((Object)certInfo, (String)"certInfo");
        if (!certInfo.hasBothCertificates() || !certInfo.isUpToDate()) {
            return;
        }
        Screenname sn = certInfo.getBuddy();
        ByteBlock hash = certInfo.getCertificateInfoHash();
        BuddyHashHolder hashHolder = new BuddyHashHolder(sn, hash);
        BuddyTrustManager buddyTrustManager = this;
        synchronized (buddyTrustManager) {
            if (this.cachedCertInfos.containsKey(hashHolder)) {
                return;
            }
            BuddyCertificateInfoHolder certInfoHolder = new BuddyCertificateInfoHolder(certInfo);
            this.cachedCertInfos.put(hashHolder, certInfoHolder);
        }
        this.certTrustMgr.addTrackedCertificateInfo(certInfo);
    }

    private synchronized BuddyCertificateInfoHolder getCurrentCertificateInfoHolder(Screenname sn) {
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        ByteBlock hash = this.getCurrentCertificateInfoHash(sn);
        if (hash == null) {
            return null;
        }
        return this.getCertificateInfoHolder(sn, hash);
    }

    private synchronized BuddyCertificateInfoHolder getCertificateInfoHolder(Screenname sn, ByteBlock hash) {
        DefensiveTools.checkNull((Object)sn, (String)"sn");
        if (hash == null) {
            return null;
        }
        BuddyHashHolder holder = new BuddyHashHolder(sn, hash);
        return this.cachedCertInfos.get(holder);
    }

    public synchronized ByteBlock getCurrentCertificateInfoHash(Screenname sn) {
        return this.latestInfos.get(sn).getCertificateInfoHash();
    }

    public synchronized boolean isTrusted(Screenname buddy) {
        BuddyCertificateInfoHolder holder = this.getCurrentCertificateInfoHolder(buddy);
        return holder != null && holder.isTrusted();
    }

    public synchronized boolean isTrusted(BuddyCertificateInfo info) {
        DefensiveTools.checkNull((Object)info, (String)"info");
        BuddyCertificateInfoHolder holder = this.getCertificateInfoHolder(info.getBuddy(), info.getCertificateInfoHash());
        return holder != null && holder.isTrusted();
    }

    private static class TrustStatus {
        public static final TrustStatus UNKNOWN = new TrustStatus("UNKNOWN");
        public static final TrustStatus NOT_TRUSTED = new TrustStatus("NOT_TRUSTED");
        public static final TrustStatus TRUSTED = new TrustStatus("TRUSTED");
        private final String name;

        public TrustStatus(String name) {
            DefensiveTools.checkNull((Object)name, (String)"name");
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class BuddyTrustInfoHolder {
        private final Screenname buddy;
        private TrustStatus trustedStatus = TrustStatus.UNKNOWN;

        public BuddyTrustInfoHolder(Screenname buddy) {
            DefensiveTools.checkNull((Object)buddy, (String)"buddy");
            this.buddy = buddy;
        }

        public Screenname getBuddy() {
            return this.buddy;
        }

        public synchronized TrustStatus getTrustedStatus() {
            return this.trustedStatus;
        }

        public synchronized void setTrustedStatus(TrustStatus trustedStatus) {
            DefensiveTools.checkNull((Object)trustedStatus, (String)"trustedStatus");
            this.trustedStatus = trustedStatus;
        }
    }

    private static class BuddyCertificateInfoHolder {
        private final BuddyCertificateInfo info;
        private boolean trusted = false;

        public BuddyCertificateInfoHolder(BuddyCertificateInfo info) {
            DefensiveTools.checkNull((Object)info, (String)"info");
            this.info = info;
        }

        public BuddyCertificateInfo getInfo() {
            return this.info;
        }

        public synchronized boolean isTrusted() {
            return this.trusted;
        }

        public synchronized void setTrusted(boolean trusted) {
            this.trusted = trusted;
        }
    }
}

