/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import weblogic.utils.collections.CircularQueue;
import weblogic.xml.babel.adapters.ElementConsumer;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.NullEvent;

public class SubXMLInputStream
extends XMLInputStreamBase
implements XMLInputStream,
ElementConsumer {
    protected XMLInputStreamBase parent;
    protected int startTags;
    protected int endTags;

    public SubXMLInputStream(XMLInputStreamBase xMLInputStreamBase) {
        this.elementQ = new CircularQueue(8);
        this.startTags = 0;
        this.endTags = 0;
        this.open = true;
        this.init(xMLInputStreamBase);
    }

    protected void init(XMLInputStreamBase xMLInputStreamBase) {
        this.parent = xMLInputStreamBase;
        xMLInputStreamBase.addChild(this);
    }

    public boolean empty() {
        return this.elementQ.isEmpty();
    }

    public boolean hasNext() throws XMLStreamException {
        if (!this.empty()) {
            return true;
        }
        if (!this.open) {
            return false;
        }
        return this.parseSome();
    }

    public XMLEvent next() throws XMLStreamException {
        if (this.needsMore()) {
            this.parseSome();
        }
        return this.get();
    }

    public boolean add(Object object) {
        XMLEvent xMLEvent = (XMLEvent)object;
        if (XMLInputStreamBase.debugSubStream) {
            System.out.println("ADD SubXMLInputStreamBaseCallback[" + xMLEvent + "][" + this.startTags + "][" + this.endTags + "]");
        }
        if (this.open && object != null) {
            switch (xMLEvent.getType()) {
                case 2: {
                    ++this.startTags;
                    break;
                }
                case 4: {
                    ++this.endTags;
                    if (this.startTags > this.endTags) break;
                    this.open = false;
                    break;
                }
                case 128: 
                case 512: {
                    this.open = false;
                }
            }
            if (XMLInputStreamBase.debugSubStream) {
                System.out.println("Added to child[" + this.open + "]");
            }
            super.add(object);
        }
        return this.open;
    }

    public boolean parseSome() throws XMLStreamException {
        if (XMLInputStreamBase.debugSubStream) {
            System.out.println("Parsing Some in Sub Stream");
        }
        return this.parent.parseSome();
    }

    public XMLEvent peek() throws XMLStreamException {
        if (!this.elementQ.isEmpty()) {
            return (XMLEvent)this.elementQ.peek();
        }
        if (XMLInputStreamBase.debugSubStream) {
            System.out.println("SubXMLinputStream:peek(0)");
        }
        if (this.parseSome() && !this.elementQ.isEmpty()) {
            return (XMLEvent)this.elementQ.peek();
        }
        if (XMLInputStreamBase.debugSubStream) {
            System.out.println("SubXMLinputStream:peek(1)");
        }
        if (this.parseSome() && !this.elementQ.isEmpty()) {
            return (XMLEvent)this.elementQ.peek();
        }
        if (XMLInputStreamBase.debugSubStream) {
            System.out.println("SubXMLinputStream:peek(FAIL)");
        }
        return new NullEvent();
    }

    public void close() throws XMLStreamException {
        this.parent.removeChild(this);
        super.close();
    }

    public static void main(String[] stringArray) throws Exception {
        StartElement startElement;
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.open(SAXElementFactory.createInputSource(stringArray[0]));
        xMLInputStreamBase.skip(2);
        xMLInputStreamBase.next();
        XMLInputStream xMLInputStream = xMLInputStreamBase.getSubStream();
        System.out.println("GETTING MULTIPLE STREAMS");
        while (xMLInputStream.skip(2)) {
            startElement = (StartElement)xMLInputStream.next();
            System.out.print("START EVENT: " + startElement.getTypeAsString() + " [");
            System.out.print(startElement);
            System.out.print("][");
            System.out.print(startElement.getNamespaceUri("a"));
            System.out.print("][");
            System.out.print(startElement.getNamespaceUri("o"));
            System.out.println("]");
        }
        xMLInputStream.close();
        xMLInputStream = xMLInputStreamBase.getSubStream();
        System.out.println("GETTING MULTIPLE STREAMS");
        while (xMLInputStream.skip(4)) {
            startElement = xMLInputStream.next();
            System.out.print("END EVENT: " + startElement.getTypeAsString() + " [");
            System.out.print(startElement);
            System.out.println("]");
        }
        xMLInputStream.close();
        System.out.println("CHECKING IF STREAM REWOUND");
        while (xMLInputStreamBase.hasNext()) {
            startElement = xMLInputStreamBase.next();
            System.out.print("CACHED EVENT: " + startElement.getTypeAsString() + " [");
            System.out.print(startElement);
            System.out.println("]");
        }
    }
}

