/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml;

import java.util.LinkedHashMap;
import java.util.Map;

public final class MsnProtocol {
    public static final MsnProtocol MSNP8 = new MsnProtocol("MSNP8", 8);
    public static final MsnProtocol MSNP9 = new MsnProtocol("MSNP9", 9);
    public static final MsnProtocol MSNP10 = new MsnProtocol("MSNP10", 10);
    public static final MsnProtocol MSNP11 = new MsnProtocol("MSNP11", 11);
    public static final MsnProtocol MSNP12 = new MsnProtocol("MSNP12", 12);
    private static Map protocolMap = new LinkedHashMap();
    private final String protocol;
    private final int version;

    public static MsnProtocol parseStr(String string) {
        return string == null ? null : (MsnProtocol)protocolMap.get(string.toUpperCase());
    }

    public static MsnProtocol[] getAllSupportedProtocol() {
        return protocolMap.values().toArray(new MsnProtocol[0]);
    }

    private MsnProtocol(String string, int n) {
        this.protocol = string;
        this.version = n;
    }

    public boolean before(MsnProtocol msnProtocol) {
        return this.version < msnProtocol.version;
    }

    public boolean after(MsnProtocol msnProtocol) {
        return this.version > msnProtocol.version;
    }

    public String toString() {
        return this.protocol;
    }

    static {
        protocolMap.put(MSNP12.toString().toUpperCase(), MSNP12);
        protocolMap.put(MSNP11.toString().toUpperCase(), MSNP11);
        protocolMap.put(MSNP10.toString().toUpperCase(), MSNP10);
        protocolMap.put(MSNP9.toString().toUpperCase(), MSNP9);
        protocolMap.put(MSNP8.toString().toUpperCase(), MSNP8);
    }
}

