/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.web;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Closer;
import com.voxeo.web.CompressorFilterErrorReporter;
import com.voxeo.web.InvalidScriptException;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class ResourceCompressor {
    private static final Loggerf log = Loggerf.getLogger(ResourceCompressor.class);
    private int lineBreakPos = -1;
    private boolean warn = false;
    private boolean munge = true;
    private boolean preserveAllSemiColons = false;
    private boolean disableOptimizations = true;

    public ResourceCompressor() {
    }

    public ResourceCompressor(int lineBreakPos, boolean warn, boolean munge, boolean preserveAllSemiColons, boolean disableOptimizations) {
        this.lineBreakPos = lineBreakPos;
        this.warn = warn;
        this.munge = munge;
        this.preserveAllSemiColons = preserveAllSemiColons;
        this.disableOptimizations = disableOptimizations;
    }

    public String minify(String resourceName, InputStream stream) throws IOException, InvalidScriptException {
        String result;
        long startTime = System.currentTimeMillis();
        if (resourceName.endsWith(".js")) {
            result = this.getCompressedJavaScript(stream);
        } else if (resourceName.endsWith(".css")) {
            result = this.getCompressedCss(stream);
        } else {
            throw new IllegalArgumentException("Resource not supported: " + resourceName);
        }
        log.info("Compressed resource %s in %sms", resourceName, System.currentTimeMillis() - startTime);
        return result;
    }

    public boolean handles(String resourceName) {
        return resourceName.endsWith(".js") || resourceName.endsWith(".css");
    }

    private String getCompressedJavaScript(InputStream inputStream) throws IOException, InvalidScriptException {
        String string;
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(inputStream);
            CompressorFilterErrorReporter errorReporter = new CompressorFilterErrorReporter();
            JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)isr, (ErrorReporter)errorReporter);
            if (errorReporter.hasRuntimeError()) {
                throw new InvalidScriptException("Failed to compress resource");
            }
            StringWriter out = new StringWriter();
            compressor.compress((Writer)out, this.lineBreakPos, this.munge, this.warn, this.preserveAllSemiColons, this.disableOptimizations);
            out.flush();
            StringBuffer buffer = out.getBuffer();
            string = buffer.toString();
        }
        catch (EvaluatorException e) {
            try {
                throw new InvalidScriptException("Failed to parse resource", e);
            }
            catch (Throwable throwable) {
                Closer.close(isr);
                throw throwable;
            }
        }
        Closer.close(isr);
        return string;
    }

    private String getCompressedCss(InputStream inputStream) throws IOException {
        InputStreamReader isr = new InputStreamReader(inputStream);
        CssCompressor compressor = new CssCompressor((Reader)isr);
        inputStream.close();
        StringWriter out = new StringWriter();
        compressor.compress((Writer)out, this.lineBreakPos);
        out.flush();
        StringBuffer buffer = out.getBuffer();
        return buffer.toString();
    }
}

