/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.proxy.ProxyServlet;

public class ProxyServletImpl
extends ProxyServlet.Transparent {
    private String proxyTo;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String proxyTo = config.getInitParameter("proxyTo");
        if (proxyTo != null && !proxyTo.endsWith("/")) {
            this.proxyTo = proxyTo;
        }
    }

    protected URI rewriteURI(HttpServletRequest request) {
        int len;
        String rewrittenPath;
        String requestPath;
        URI rewrittenURI = super.rewriteURI(request);
        if (this.proxyTo != null && (requestPath = request.getRequestURI()) != null && !requestPath.endsWith("/") && (rewrittenPath = rewrittenURI.getPath()) != null && (len = rewrittenPath.length()) > 1 && rewrittenPath.endsWith("/")) {
            rewrittenPath = rewrittenPath.substring(0, len - 1);
            try {
                rewrittenURI = new URI(rewrittenURI.getScheme(), rewrittenURI.getAuthority(), rewrittenPath, rewrittenURI.getQuery(), rewrittenURI.getFragment());
            }
            catch (URISyntaxException urise) {
                // empty catch block
            }
        }
        return rewrittenURI;
    }
}

