/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message.p2p;

import java.nio.ByteBuffer;
import net.sf.jml.MsnContact;
import net.sf.jml.impl.MsnFileTransferImpl;
import net.sf.jml.message.p2p.MsnP2PMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.util.NumberUtils;
import net.sf.jml.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MsnFileDataMessage
extends MsnP2PMessage {
    private static final Log logger = LogFactory.getLog(MsnFileDataMessage.class);
    public static final int MAX_DATA_LENGTH = 1202;
    private byte[] body;

    public MsnFileDataMessage() {
        this.setFlag(0x1000030);
    }

    public MsnFileDataMessage(int n, int n2, int n3, int n4, byte[] byArray, String string) {
        this.body = byArray;
        this.setP2PDest(string);
        this.setSessionId(n);
        this.setIdentifier(n2);
        this.setOffset(n3);
        this.setTotalLength(n4);
        this.setCurrentLength(this.body.length);
        this.setFlag(32);
        this.setField7(NumberUtils.getIntRandom());
        this.setAppId(1);
    }

    protected byte[] bodyToMessage() {
        return this.body;
    }

    protected void parseP2PBody(ByteBuffer byteBuffer) {
        this.body = new byte[this.getCurrentLength()];
        byteBuffer.get(this.body);
    }

    protected String toDebugBody() {
        return StringUtils.debug(ByteBuffer.wrap(this.body));
    }

    protected void messageReceived(MsnSession msnSession, MsnContact msnContact) {
        MsnFileTransferImpl msnFileTransferImpl = (MsnFileTransferImpl)msnSession.getMessenger().getFileTransferManager().getFileTransfer(String.valueOf(this.getSessionId()));
        if (msnFileTransferImpl != null) {
            msnFileTransferImpl.process(this.body, this.getCurrentLength(), this.getTotalLength(), this.getOffset(), this);
        } else {
            logger.error((Object)"Unknown filetransfer!");
        }
    }
}

