/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;

public abstract class Packet {
    protected static DocumentFactory docFactory = DocumentFactory.getInstance();
    protected Element element;

    public Packet(Element element) {
        String from;
        this.element = element;
        String to = element.attributeValue("to");
        if (to != null) {
            JID toJID = new JID(to);
            element.addAttribute("to", toJID.toString());
        }
        if ((from = element.attributeValue("from")) != null) {
            JID fromJID = new JID(from);
            element.addAttribute("from", fromJID.toString());
        }
    }

    public String getID() {
        return this.element.attributeValue("id");
    }

    public void setID(String ID) {
        this.element.addAttribute("id", ID);
    }

    public JID getTo() {
        String to = this.element.attributeValue("to");
        if (to == null) {
            return null;
        }
        return new JID(to, null);
    }

    public void setTo(String to) {
        if (to != null) {
            to = new JID(to).toString();
        }
        this.element.addAttribute("to", to);
    }

    public void setTo(JID to) {
        if (to == null) {
            this.element.addAttribute("to", null);
        } else {
            this.setTo(to.toString());
        }
    }

    public JID getFrom() {
        String from = this.element.attributeValue("from");
        if (from == null) {
            return null;
        }
        return new JID(from, null);
    }

    public void setFrom(String from) {
        if (from != null) {
            from = new JID(from).toString();
        }
        this.element.addAttribute("from", from);
    }

    public void setFrom(JID from) {
        if (from == null) {
            this.element.addAttribute("from", null);
        } else {
            this.setFrom(from.toString());
        }
    }

    public PacketError getError() {
        Element error = this.element.element("error");
        if (error != null) {
            return new PacketError(this.element);
        }
        return null;
    }

    public void setError(PacketError error) {
        if (this.element == null) {
            throw new NullPointerException("Error cannot be null");
        }
        this.element.addAttribute("type", "error");
        if (this.element.element("error") != null) {
            this.element.remove(this.element.element("error"));
        }
        this.element.add(error.getElement());
    }

    public void setError(PacketError.Condition condition) {
        this.setError(new PacketError(condition));
    }

    public abstract Packet createCopy();

    public Element getElement() {
        return this.element;
    }

    public String toXML() {
        return this.element.asXML();
    }

    public String toString() {
        StringWriter out = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)out, OutputFormat.createPrettyPrint());
        try {
            writer.write(this.element);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out.toString();
    }
}

