/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Closer;
import com.voxeo.utils.Constraint;
import com.voxeo.utils.ObjectCallback;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBC {
    private static final Loggerf log = Loggerf.getLogger(JDBC.class);

    public static void rollback(Connection conn) {
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (Exception e) {
                log.error("Exception while rolling back transaction!", e);
            }
        }
    }

    public static void close(Connection conn, Statement statement, ResultSet rs) {
        JDBC.close(rs);
        JDBC.close(statement);
        JDBC.close(conn);
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception e) {
                log.error("Exception while closing JDBC connection!", e);
            }
        }
    }

    public static void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception e) {
                log.error("Exception while closing JDBC statement!", e);
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                log.error("Exception while closing JDBC result set!", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSequenceValue(Connection conn, String name) throws SQLException {
        CallableStatement cs = null;
        try {
            cs = conn.prepareCall("{ ? = call usp_get_sequence_value(?) }");
            cs.registerOutParameter(1, 4);
            cs.setString(2, name);
            cs.executeUpdate();
            int n = cs.getInt(1);
            return n;
        }
        finally {
            JDBC.close(cs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean columnExists(DataSource dataSource, String tableName, String columnName) throws SQLException {
        boolean bl;
        ResultSet columns = null;
        Connection conn = dataSource.getConnection();
        try {
            DatabaseMetaData dbMetadata = conn.getMetaData();
            columns = dbMetadata.getColumns(conn.getCatalog(), null, tableName.toUpperCase(), columnName.toUpperCase());
            bl = columns.next();
        }
        catch (Throwable throwable) {
            Closer.closeAll(columns, conn);
            throw throwable;
        }
        Closer.closeAll(columns, conn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean constraintExists(DataSource dataSource, String tableName, String constraintName) throws SQLException {
        boolean bl;
        ResultSet constraints = null;
        PreparedStatement statement = null;
        Connection conn = dataSource.getConnection();
        try {
            statement = conn.prepareStatement("select * from information_schema.constraints where table_name = ? and constraint_name = ?");
            statement.setString(1, tableName.toUpperCase());
            statement.setString(2, constraintName.toUpperCase());
            constraints = statement.executeQuery();
            bl = constraints.next();
        }
        catch (Throwable throwable) {
            Closer.closeAll(constraints, statement, conn);
            throw throwable;
        }
        Closer.closeAll(constraints, statement, conn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Constraint> findConstraintsForColumn(DataSource dataSource, String tableName, String columnName) throws SQLException {
        LinkedList<Constraint> linkedList;
        ResultSet constraints = null;
        PreparedStatement statement = null;
        Connection conn = dataSource.getConnection();
        try {
            statement = conn.prepareStatement("select * from information_schema.constraints where table_name = ? and COLUMN_LIST like ?");
            statement.setString(1, tableName.toUpperCase());
            statement.setString(2, String.format("%%%s%%", columnName.toUpperCase()));
            constraints = statement.executeQuery();
            LinkedList<Constraint> result = new LinkedList<Constraint>();
            while (constraints.next()) {
                Constraint constraint = new Constraint();
                constraint.setName(constraints.getString("CONSTRAINT_NAME"));
                constraint.setTableName(constraints.getString("TABLE_NAME"));
                constraint.setColumns(constraints.getString("COLUMN_LIST").split(","));
                constraint.setType(JDBC.parseConstraintType(constraints.getString("CONSTRAINT_TYPE")));
                result.add(constraint);
            }
            linkedList = result;
        }
        catch (Throwable throwable) {
            Closer.closeAll(constraints, statement, conn);
            throw throwable;
        }
        Closer.closeAll(constraints, statement, conn);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> findIndexesForConstraint(DataSource dataSource, String tableName, String constraintName) throws SQLException {
        HashSet<String> hashSet;
        ResultSet indexes = null;
        PreparedStatement statement = null;
        Connection conn = dataSource.getConnection();
        try {
            statement = conn.prepareStatement("select * from information_schema.indexes where table_name = ? and constraint_name = ?");
            statement.setString(1, tableName.toUpperCase());
            statement.setString(2, constraintName.toUpperCase());
            indexes = statement.executeQuery();
            HashSet<String> result = new HashSet<String>();
            while (indexes.next()) {
                result.add(indexes.getString("index_name"));
            }
            hashSet = result;
        }
        catch (Throwable throwable) {
            Closer.closeAll(indexes, statement, conn);
            throw throwable;
        }
        Closer.closeAll(indexes, statement, conn);
        return hashSet;
    }

    private static Constraint.Type parseConstraintType(String typeName) {
        if ("UNIQUE".equals(typeName)) {
            return Constraint.Type.UNIQUE;
        }
        return Constraint.Type.OTHER;
    }

    public static void logRow(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        StringBuilder buffer = new StringBuilder();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(metaData.getColumnLabel(i));
            buffer.append("=");
            buffer.append(rs.getObject(i));
        }
        log.debug("Row: [%s]", buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forEachTableName(DataSource dataSource, ObjectCallback<String> callback) throws SQLException {
        Connection conn = dataSource.getConnection();
        ResultSet rs = null;
        try {
            rs = conn.getMetaData().getTables(conn.getCatalog(), null, "%", null);
            while (rs.next()) {
                callback.process(rs.getString("TABLE_NAME"));
            }
        }
        catch (Throwable throwable) {
            Closer.closeAll(rs, conn);
            throw throwable;
        }
        Closer.closeAll(rs, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasIdentityColumn(DataSource dataSource, String tableName) throws SQLException {
        boolean bl;
        Connection conn = dataSource.getConnection();
        ResultSet rs = null;
        try {
            rs = conn.getMetaData().getColumns(conn.getCatalog(), null, tableName, null);
            while (rs.next()) {
                if (rs.getString("TYPE_NAME").indexOf("identity") == -1) continue;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            Closer.closeAll(rs, conn);
            throw throwable;
        }
        {
            Closer.closeAll(rs, conn);
            return bl;
        }
        boolean bl2 = false;
        Closer.closeAll(rs, conn);
        return bl2;
    }
}

