/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.rooms;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.rooms.ExchangeInfoReq;
import net.kano.joscar.snaccmd.rooms.JoinRoomCmd;
import net.kano.joscar.snaccmd.rooms.RoomInfoReq;
import net.kano.joscar.snaccmd.rooms.RoomRightsRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerRoomCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList((Object[])new CmdType[]{new CmdType(13, 2), new CmdType(13, 3), new CmdType(13, 4), new CmdType(13, 8)});

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket packet) {
        if (packet.getFamily() != 13) {
            return null;
        }
        int command = packet.getCommand();
        if (command == 2) {
            return new RoomRightsRequest(packet);
        }
        if (command == 3) {
            return new ExchangeInfoReq(packet);
        }
        if (command == 4) {
            return new RoomInfoReq(packet);
        }
        if (command == 8) {
            return new JoinRoomCmd(packet);
        }
        return null;
    }
}

