/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.jodatime;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.annotation.HandleBeanView;
import com.owlike.genson.annotation.HandleClassMetadata;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import com.owlike.genson.stream.ValueType;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

@HandleClassMetadata
@HandleBeanView
public abstract class BaseReadableInstantConverter<T extends ReadableInstant>
implements Converter<T> {
    protected final boolean dateAsMillis;
    protected final DateTimeFormatter formatter;

    protected BaseReadableInstantConverter(boolean dateAsMillis, DateTimeFormatter formatter) {
        this.dateAsMillis = dateAsMillis;
        this.formatter = formatter;
    }

    protected abstract T fromLong(long var1);

    protected abstract T fromString(String var1);

    @Override
    public void serialize(ReadableInstant object, ObjectWriter writer, Context ctx) throws Exception {
        if (this.dateAsMillis) {
            writer.writeValue(object.getMillis());
        } else {
            writer.writeString(this.formatter.print(object));
        }
    }

    @Override
    public T deserialize(ObjectReader reader, Context ctx) throws Exception {
        if (ValueType.INTEGER == reader.getValueType()) {
            return this.fromLong(reader.valueAsLong());
        }
        return this.fromString(reader.valueAsString());
    }

    static BaseReadableInstantConverter<DateTime> makeDateTimeConverter(boolean dateAsMillis, DateTimeFormatter formatter) {
        return new BaseReadableInstantConverter<DateTime>(dateAsMillis, formatter){

            @Override
            protected DateTime fromLong(long value) {
                return new DateTime(value);
            }

            @Override
            protected DateTime fromString(String value) {
                return this.formatter.parseDateTime(value);
            }
        };
    }

    static BaseReadableInstantConverter<MutableDateTime> makeMutableDateTimeConverter(boolean dateAsMillis, DateTimeFormatter formatter) {
        return new BaseReadableInstantConverter<MutableDateTime>(dateAsMillis, formatter){

            @Override
            protected MutableDateTime fromLong(long value) {
                return new MutableDateTime(value);
            }

            @Override
            protected MutableDateTime fromString(String value) {
                return this.formatter.parseMutableDateTime(value);
            }
        };
    }

    static BaseReadableInstantConverter<Instant> makeInstantConverter(boolean dateAsMillis, DateTimeFormatter formatter) {
        return new BaseReadableInstantConverter<Instant>(dateAsMillis, formatter){

            @Override
            protected Instant fromLong(long value) {
                return new Instant(value);
            }

            @Override
            protected Instant fromString(String value) {
                return new Instant((Object)value);
            }
        };
    }
}

