/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.spring.properties;

import com.voxeo.spring.properties.DelegatingProperties;
import com.voxeo.spring.properties.PropertiesReloadedEvent;
import com.voxeo.spring.properties.ReloadableProperties;
import com.voxeo.spring.properties.ReloadablePropertiesListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadablePropertiesBase
extends DelegatingProperties
implements ReloadableProperties {
    private static final long serialVersionUID = 7300087471244983481L;
    private List<ReloadablePropertiesListener> listeners = new ArrayList<ReloadablePropertiesListener>();
    private Properties internalProperties;

    public void setListeners(List<ReloadablePropertiesListener> listeners) {
        this.listeners = listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Properties getDelegate() {
        ReloadablePropertiesBase reloadablePropertiesBase = this;
        synchronized (reloadablePropertiesBase) {
            return this.internalProperties;
        }
    }

    @Override
    public Properties getProperties() {
        return this.getDelegate();
    }

    @Override
    public void addReloadablePropertiesListener(ReloadablePropertiesListener l) {
        this.listeners.add(l);
    }

    @Override
    public boolean removeReloadablePropertiesListener(ReloadablePropertiesListener l) {
        return this.listeners.remove(l);
    }

    protected void notifyPropertiesChanged(Properties oldProperties) {
        PropertiesReloadedEvent event = new PropertiesReloadedEvent(this, oldProperties);
        for (ReloadablePropertiesListener listener : this.listeners) {
            listener.propertiesReloaded(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProperties(Properties properties) {
        Properties oldProperties = this.internalProperties;
        ReloadablePropertiesBase reloadablePropertiesBase = this;
        synchronized (reloadablePropertiesBase) {
            this.internalProperties = properties;
        }
        this.notifyPropertiesChanged(oldProperties);
    }
}

