/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header.extensions;

import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.extensions.SessionExpiresHeader;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.ExtensionHeader;

public final class SessionExpires
extends ParametersHeader
implements ExtensionHeader,
SessionExpiresHeader {
    private static final long serialVersionUID = 8765762413224043300L;
    public static final String NAME = "Session-Expires";
    public int expires;
    public static final String REFRESHER = "refresher";

    public SessionExpires() {
        super(NAME);
    }

    public int getExpires() {
        return this.expires;
    }

    public void setExpires(int expires) throws InvalidArgumentException {
        if (expires < 0) {
            throw new InvalidArgumentException("bad argument " + expires);
        }
        this.expires = expires;
    }

    public void setValue(String value) throws ParseException {
        throw new ParseException(value, 0);
    }

    protected StringBuilder encodeBody(StringBuilder retval) {
        retval.append(Integer.toString(this.expires));
        if (!this.parameters.isEmpty()) {
            retval.append(";");
            this.parameters.encode(retval);
        }
        return retval;
    }

    public String getRefresher() {
        return this.parameters.getParameter(REFRESHER);
    }

    public void setRefresher(String refresher) {
        this.parameters.set(REFRESHER, refresher);
    }
}

