/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ServiceObserver<T>
implements ServiceListener {
    private final List<T> services = new ArrayList<T>();
    private final Class<T> className;
    private BundleContext context;

    public ServiceObserver(Class<T> className) {
        this.className = className;
    }

    public void start(BundleContext ctx) {
        ServiceReference[] refs;
        this.context = ctx;
        ctx.addServiceListener((ServiceListener)this);
        for (ServiceReference ref : refs = ServiceUtils.getServiceReferences(ctx, this.className)) {
            this.services.add(ctx.getService(ref));
        }
    }

    public void stop(BundleContext ctx) {
        ctx.removeServiceListener((ServiceListener)this);
        this.services.clear();
        this.context = null;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        Object service = this.context.getService(serviceEvent.getServiceReference());
        if (!this.className.isInstance(service)) {
            return;
        }
        int eventType = serviceEvent.getType();
        if (eventType == 1) {
            this.services.add(service);
        } else if (eventType == 4) {
            this.services.remove(service);
        }
    }

    public List<T> getServices() {
        return Collections.unmodifiableList(this.services);
    }
}

