/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.ApplicationEvent;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.NewParticipantEvent;
import javax.media.rtp.event.ReceiverReportEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.StreamMappedEvent;
import javax.media.rtp.rtcp.ReceiverReport;
import javax.media.rtp.rtcp.SenderReport;
import net.sf.fmj.media.rtp.PassiveSSRCInfo;
import net.sf.fmj.media.rtp.RTCPAPPPacket;
import net.sf.fmj.media.rtp.RTCPBYEPacket;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPRawReceiver;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPSDES;
import net.sf.fmj.media.rtp.RTCPSDESPacket;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import net.sf.fmj.media.rtp.RTPSourceInfo;
import net.sf.fmj.media.rtp.RecvSSRCInfo;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.StreamSynch;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketConsumer;
import net.sf.fmj.media.rtp.util.PacketForwarder;
import net.sf.fmj.media.rtp.util.PacketSource;
import net.sf.fmj.media.rtp.util.UDPPacket;

public class RTCPReceiver
implements PacketConsumer {
    private static final int SR = 1;
    private static final int RR = 2;
    private boolean rtcpstarted = false;
    private boolean sentrecvstrmap = false;
    SSRCCache cache;
    private int type = 0;

    public RTCPReceiver(SSRCCache ssrccache) {
        this.cache = ssrccache;
        SSRCInfo ssrcinfo = ssrccache.lookup(ssrccache.ourssrc.ssrc);
    }

    public RTCPReceiver(SSRCCache ssrccache, DatagramSocket datagramsocket, StreamSynch streamsynch) {
        this(ssrccache, new RTCPRawReceiver(datagramsocket, ssrccache.sm.defaultstats, streamsynch));
    }

    public RTCPReceiver(SSRCCache ssrccache, int i, String s, StreamSynch streamsynch) throws UnknownHostException, IOException {
        this(ssrccache, new RTCPRawReceiver(i | 1, s, ssrccache.sm.defaultstats, streamsynch));
    }

    public RTCPReceiver(SSRCCache ssrccache, PacketSource packetsource) {
        this(ssrccache);
        PacketForwarder packetforwarder = new PacketForwarder(packetsource, this);
        packetforwarder.startPF();
    }

    public void closeConsumer() {
    }

    public String consumerString() {
        return "RTCP Packet Receiver/Collector";
    }

    public void sendTo(Packet packet) {
        this.sendTo((RTCPPacket)packet);
    }

    public void sendTo(RTCPPacket rtcppacket) {
        SSRCInfo ssrcinfo = null;
        boolean flag = this.cache.sm.isUnicast();
        if (flag) {
            if (!this.rtcpstarted) {
                this.cache.sm.startRTCPReports(((UDPPacket)rtcppacket.base).remoteAddress);
                this.rtcpstarted = true;
                byte[] abyte0 = this.cache.sm.controladdress.getAddress();
                int i = abyte0[3] & 0xFF;
                if ((i & 0xFF) == 255) {
                    this.cache.sm.addUnicastAddr(this.cache.sm.controladdress);
                } else {
                    InetAddress inetaddress = null;
                    boolean flag1 = true;
                    try {
                        inetaddress = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException unknownhostexception) {
                        flag1 = false;
                    }
                    if (flag1) {
                        this.cache.sm.addUnicastAddr(inetaddress);
                    }
                }
            } else if (!this.cache.sm.isSenderDefaultAddr(((UDPPacket)rtcppacket.base).remoteAddress)) {
                this.cache.sm.addUnicastAddr(((UDPPacket)rtcppacket.base).remoteAddress);
            }
        }
        switch (rtcppacket.type) {
            default: {
                break;
            }
            case -1: {
                RTCPCompoundPacket rtcpcompoundpacket = (RTCPCompoundPacket)rtcppacket;
                this.cache.updateavgrtcpsize(rtcpcompoundpacket.length);
                for (int j = 0; j < rtcpcompoundpacket.packets.length; ++j) {
                    this.sendTo(rtcpcompoundpacket.packets[j]);
                }
                if (this.cache.sm.cleaner == null) break;
                this.cache.sm.cleaner.setClean();
                break;
            }
            case 200: {
                RTCPSRPacket rtcpsrpacket = (RTCPSRPacket)rtcppacket;
                this.type = 1;
                ssrcinfo = rtcppacket.base instanceof UDPPacket ? this.cache.get(rtcpsrpacket.ssrc, ((UDPPacket)rtcppacket.base).remoteAddress, ((UDPPacket)rtcppacket.base).remotePort, 1) : this.cache.get(rtcpsrpacket.ssrc, null, 0, 1);
                if (ssrcinfo == null) break;
                ssrcinfo.setAlive(true);
                ssrcinfo.lastSRntptimestamp = (rtcpsrpacket.ntptimestampmsw << 32) + rtcpsrpacket.ntptimestamplsw;
                ssrcinfo.lastSRrtptimestamp = rtcpsrpacket.rtptimestamp;
                ssrcinfo.lastSRreceiptTime = rtcpsrpacket.receiptTime;
                ssrcinfo.lastRTCPreceiptTime = rtcpsrpacket.receiptTime;
                ssrcinfo.lastHeardFrom = rtcpsrpacket.receiptTime;
                if (ssrcinfo.quiet) {
                    ssrcinfo.quiet = false;
                    ActiveReceiveStreamEvent activereceivestreamevent = null;
                    activereceivestreamevent = ssrcinfo instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, ssrcinfo.sourceInfo, (ReceiveStream)((Object)ssrcinfo)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, ssrcinfo.sourceInfo, null);
                    this.cache.eventhandler.postEvent(activereceivestreamevent);
                }
                ssrcinfo.lastSRpacketcount = rtcpsrpacket.packetcount;
                ssrcinfo.lastSRoctetcount = rtcpsrpacket.octetcount;
                for (int k = 0; k < rtcpsrpacket.reports.length; ++k) {
                    rtcpsrpacket.reports[k].receiptTime = rtcpsrpacket.receiptTime;
                    int l = rtcpsrpacket.reports[k].ssrc;
                    RTCPReportBlock[] artcpreportblock = ssrcinfo.reports.get(l);
                    if (artcpreportblock == null) {
                        artcpreportblock = new RTCPReportBlock[2];
                        artcpreportblock[0] = rtcpsrpacket.reports[k];
                        ssrcinfo.reports.put(l, artcpreportblock);
                        continue;
                    }
                    artcpreportblock[1] = artcpreportblock[0];
                    artcpreportblock[0] = rtcpsrpacket.reports[k];
                }
                if (ssrcinfo.probation > 0) break;
                if (!ssrcinfo.newpartsent && ssrcinfo.sourceInfo != null) {
                    NewParticipantEvent newparticipantevent = new NewParticipantEvent(this.cache.sm, ssrcinfo.sourceInfo);
                    this.cache.eventhandler.postEvent(newparticipantevent);
                    ssrcinfo.newpartsent = true;
                }
                if (!ssrcinfo.recvstrmap && ssrcinfo.sourceInfo != null) {
                    ssrcinfo.recvstrmap = true;
                    StreamMappedEvent streammappedevent = new StreamMappedEvent(this.cache.sm, (ReceiveStream)((Object)ssrcinfo), ssrcinfo.sourceInfo);
                    this.cache.eventhandler.postEvent(streammappedevent);
                }
                SenderReportEvent senderreportevent = new SenderReportEvent(this.cache.sm, (SenderReport)((Object)ssrcinfo));
                this.cache.eventhandler.postEvent(senderreportevent);
                break;
            }
            case 201: {
                RTCPRRPacket rtcprrpacket = (RTCPRRPacket)rtcppacket;
                this.type = 2;
                ssrcinfo = rtcppacket.base instanceof UDPPacket ? this.cache.get(rtcprrpacket.ssrc, ((UDPPacket)rtcppacket.base).remoteAddress, ((UDPPacket)rtcppacket.base).remotePort, 2) : this.cache.get(rtcprrpacket.ssrc, null, 0, 2);
                if (ssrcinfo == null) break;
                ssrcinfo.setAlive(true);
                ssrcinfo.lastRTCPreceiptTime = rtcprrpacket.receiptTime;
                ssrcinfo.lastHeardFrom = rtcprrpacket.receiptTime;
                if (ssrcinfo.quiet) {
                    ssrcinfo.quiet = false;
                    ActiveReceiveStreamEvent activereceivestreamevent1 = null;
                    activereceivestreamevent1 = ssrcinfo instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, ssrcinfo.sourceInfo, (ReceiveStream)((Object)ssrcinfo)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, ssrcinfo.sourceInfo, null);
                    this.cache.eventhandler.postEvent(activereceivestreamevent1);
                }
                for (int i1 = 0; i1 < rtcprrpacket.reports.length; ++i1) {
                    rtcprrpacket.reports[i1].receiptTime = rtcprrpacket.receiptTime;
                    int j1 = rtcprrpacket.reports[i1].ssrc;
                    RTCPReportBlock[] artcpreportblock1 = ssrcinfo.reports.get(j1);
                    if (artcpreportblock1 == null) {
                        artcpreportblock1 = new RTCPReportBlock[2];
                        artcpreportblock1[0] = rtcprrpacket.reports[i1];
                        ssrcinfo.reports.put(j1, artcpreportblock1);
                        continue;
                    }
                    artcpreportblock1[1] = artcpreportblock1[0];
                    artcpreportblock1[0] = rtcprrpacket.reports[i1];
                }
                if (!ssrcinfo.newpartsent && ssrcinfo.sourceInfo != null) {
                    NewParticipantEvent newparticipantevent1 = new NewParticipantEvent(this.cache.sm, ssrcinfo.sourceInfo);
                    this.cache.eventhandler.postEvent(newparticipantevent1);
                    ssrcinfo.newpartsent = true;
                }
                ReceiverReportEvent receiverreportevent = new ReceiverReportEvent(this.cache.sm, (ReceiverReport)((Object)ssrcinfo));
                this.cache.eventhandler.postEvent(receiverreportevent);
                break;
            }
            case 202: {
                RTCPSDESPacket rtcpsdespacket = (RTCPSDESPacket)rtcppacket;
                for (int k1 = 0; k1 < rtcpsdespacket.sdes.length; ++k1) {
                    RTCPSDES rtcpsdes = rtcpsdespacket.sdes[k1];
                    if (this.type == 1) {
                        ssrcinfo = rtcppacket.base instanceof UDPPacket ? this.cache.get(rtcpsdes.ssrc, ((UDPPacket)rtcppacket.base).remoteAddress, ((UDPPacket)rtcppacket.base).remotePort, 1) : this.cache.get(rtcpsdes.ssrc, null, 0, 1);
                    }
                    if (this.type == 2) {
                        ssrcinfo = rtcppacket.base instanceof UDPPacket ? this.cache.get(rtcpsdes.ssrc, ((UDPPacket)rtcppacket.base).remoteAddress, ((UDPPacket)rtcppacket.base).remotePort, 2) : this.cache.get(rtcpsdes.ssrc, null, 0, 2);
                    }
                    if (ssrcinfo == null) break;
                    ssrcinfo.setAlive(true);
                    ssrcinfo.lastHeardFrom = rtcpsdespacket.receiptTime;
                    ssrcinfo.addSDESInfo(rtcpsdes);
                }
                if (ssrcinfo != null && !ssrcinfo.newpartsent && ssrcinfo.sourceInfo != null) {
                    NewParticipantEvent newparticipantevent2 = new NewParticipantEvent(this.cache.sm, ssrcinfo.sourceInfo);
                    this.cache.eventhandler.postEvent(newparticipantevent2);
                    ssrcinfo.newpartsent = true;
                }
                if (ssrcinfo != null && !ssrcinfo.recvstrmap && ssrcinfo.sourceInfo != null && ssrcinfo instanceof RecvSSRCInfo) {
                    ssrcinfo.recvstrmap = true;
                    StreamMappedEvent streammappedevent1 = new StreamMappedEvent(this.cache.sm, (ReceiveStream)((Object)ssrcinfo), ssrcinfo.sourceInfo);
                    this.cache.eventhandler.postEvent(streammappedevent1);
                }
                this.type = 0;
                break;
            }
            case 203: {
                RTCPBYEPacket rtcpbyepacket = (RTCPBYEPacket)rtcppacket;
                SSRCInfo ssrcinfo1 = rtcppacket.base instanceof UDPPacket ? this.cache.get(rtcpbyepacket.ssrc[0], ((UDPPacket)rtcppacket.base).remoteAddress, ((UDPPacket)rtcppacket.base).remotePort) : this.cache.get(rtcpbyepacket.ssrc[0], null, 0);
                for (int l1 = 0; l1 < rtcpbyepacket.ssrc.length && (ssrcinfo1 = rtcppacket.base instanceof UDPPacket ? this.cache.get(rtcpbyepacket.ssrc[l1], ((UDPPacket)rtcppacket.base).remoteAddress, ((UDPPacket)rtcppacket.base).remotePort) : this.cache.get(rtcpbyepacket.ssrc[l1], null, 0)) != null; ++l1) {
                    if (this.cache.byestate) continue;
                    ssrcinfo1.setAlive(false);
                    ssrcinfo1.byeReceived = true;
                    ssrcinfo1.byeTime = rtcppacket.receiptTime;
                    ssrcinfo1.lastHeardFrom = rtcpbyepacket.receiptTime;
                }
                if (ssrcinfo1 == null) break;
                if (ssrcinfo1.quiet) {
                    ssrcinfo1.quiet = false;
                    ActiveReceiveStreamEvent activereceivestreamevent2 = null;
                    activereceivestreamevent2 = ssrcinfo1 instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, ssrcinfo1.sourceInfo, (ReceiveStream)((Object)ssrcinfo1)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, ssrcinfo1.sourceInfo, null);
                    this.cache.eventhandler.postEvent(activereceivestreamevent2);
                }
                ssrcinfo1.byereason = new String(rtcpbyepacket.reason);
                if (ssrcinfo1.byeReceived) break;
                boolean flag2 = false;
                RTPSourceInfo rtpsourceinfo = ssrcinfo1.sourceInfo;
                if (rtpsourceinfo != null && rtpsourceinfo.getStreamCount() == 0) {
                    flag2 = true;
                }
                ByeEvent byeevent = null;
                if (ssrcinfo1 instanceof RecvSSRCInfo) {
                    byeevent = new ByeEvent(this.cache.sm, ssrcinfo1.sourceInfo, (ReceiveStream)((Object)ssrcinfo1), new String(rtcpbyepacket.reason), flag2);
                }
                if (ssrcinfo1 instanceof PassiveSSRCInfo) {
                    byeevent = new ByeEvent(this.cache.sm, ssrcinfo1.sourceInfo, null, new String(rtcpbyepacket.reason), flag2);
                }
                this.cache.eventhandler.postEvent(byeevent);
                this.cache.remove(ssrcinfo1.ssrc);
                break;
            }
            case 204: {
                RTCPAPPPacket rtcpapppacket = (RTCPAPPPacket)rtcppacket;
                SSRCInfo ssrcinfo2 = rtcppacket.base instanceof UDPPacket ? this.cache.get(rtcpapppacket.ssrc, ((UDPPacket)rtcppacket.base).remoteAddress, ((UDPPacket)rtcppacket.base).remotePort) : this.cache.get(rtcpapppacket.ssrc, null, 0);
                if (ssrcinfo2 == null) break;
                ssrcinfo2.lastHeardFrom = rtcpapppacket.receiptTime;
                if (ssrcinfo2.quiet) {
                    ssrcinfo2.quiet = false;
                    ActiveReceiveStreamEvent activereceivestreamevent3 = null;
                    activereceivestreamevent3 = ssrcinfo2 instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, ssrcinfo2.sourceInfo, (ReceiveStream)((Object)ssrcinfo2)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, ssrcinfo2.sourceInfo, null);
                    this.cache.eventhandler.postEvent(activereceivestreamevent3);
                }
                ApplicationEvent applicationevent = null;
                if (ssrcinfo2 instanceof RecvSSRCInfo) {
                    applicationevent = new ApplicationEvent(this.cache.sm, ssrcinfo2.sourceInfo, (ReceiveStream)((Object)ssrcinfo2), rtcpapppacket.subtype, null, rtcpapppacket.data);
                }
                if (ssrcinfo2 instanceof PassiveSSRCInfo) {
                    applicationevent = new ApplicationEvent(this.cache.sm, ssrcinfo2.sourceInfo, null, rtcpapppacket.subtype, null, rtcpapppacket.data);
                }
                this.cache.eventhandler.postEvent(applicationevent);
            }
        }
    }
}

