/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.video;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.renderer.VideoRenderer;
import net.sf.fmj.media.renderer.video.JVideoComponent;

public class Java2dRenderer
implements VideoRenderer {
    private String name = "Java2D Video Renderer";
    private Format[] supportedFormats;
    private RGBFormat inputFormat;
    private JVideoComponent component;
    private Rectangle bounds = new Rectangle(0, 0, 10, 10);
    private BufferedImage bufferedImage;

    public Java2dRenderer() {
        int n = 0xFF0000;
        int n2 = 65280;
        int n3 = 255;
        this.supportedFormats = new Format[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, n, n2, n3, 1, -1, 0, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, 32, n3, n2, n, 1, -1, 0, -1)};
    }

    public synchronized void close() {
        this.bufferedImage = null;
    }

    private void createImage() {
        if (this.inputFormat == null) {
            return;
        }
        Dimension dimension = this.inputFormat.getSize();
        if (dimension == null) {
            return;
        }
        int n = this.inputFormat.getRedMask() == 255 ? 4 : 1;
        this.bufferedImage = new BufferedImage(dimension.width, dimension.height, n);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new JVideoComponent();
        }
        return this.component;
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public String getName() {
        return this.name;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.createImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer buffer) {
        Object object;
        if (this.component == null) {
            return 1;
        }
        Format format = buffer.getFormat();
        if (format == null) {
            return 1;
        }
        if (format != this.inputFormat || !format.equals(this.inputFormat)) {
            if (this.setInputFormat(format) == null) {
                return 1;
            }
            this.createImage();
        }
        if ((object = buffer.getData()) == null) {
            return 1;
        }
        if (format.getDataType() != Format.intArray) {
            return 1;
        }
        Dimension dimension = this.inputFormat.getSize();
        JVideoComponent jVideoComponent = this.component;
        synchronized (jVideoComponent) {
            this.bufferedImage.getRaster().setDataElements(0, 0, dimension.width, dimension.height, object);
            this.component.setImage(this.bufferedImage);
        }
        return 0;
    }

    public void reset() {
    }

    public void setBounds(Rectangle rectangle) {
        this.bounds.setBounds(rectangle);
    }

    public boolean setComponent(Component component) {
        return false;
    }

    public Format setInputFormat(Format format) {
        for (int i = 0; i < this.supportedFormats.length; ++i) {
            if (!format.matches(this.supportedFormats[i])) continue;
            this.inputFormat = (RGBFormat)format;
            Dimension dimension = this.inputFormat.getSize();
            if (dimension != null) {
                this.bounds.setSize(dimension);
            }
            this.getComponent().setPreferredSize(dimension);
            return format;
        }
        return null;
    }

    public void start() {
    }

    public void stop() {
    }
}

