/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.gsm;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.codec.audio.gsm.GSMEncoderUtil;

public class Encoder
extends AbstractCodec {
    private Buffer innerBuffer = new Buffer();
    private static final int PCM_BYTES = 320;
    private static final int GSM_BYTES = 33;
    private int innerDataLength = 0;
    byte[] innerContent;
    protected Format[] outputFormats = new Format[]{new AudioFormat("gsm", 8000.0, 8, 1, -1, 1, 264, -1.0, Format.byteArray)};
    private static final boolean TRACE = false;

    public Encoder() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 1, 1, -1, -1.0, Format.byteArray)};
    }

    public void close() {
    }

    public String getName() {
        return "GSM Encoder";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (!(format instanceof AudioFormat)) {
            return new Format[]{null};
        }
        AudioFormat audioFormat = (AudioFormat)format;
        AudioFormat audioFormat2 = new AudioFormat("gsm", audioFormat.getSampleRate(), 8, 1, audioFormat.getEndian(), 1, 264, audioFormat.getFrameRate(), Format.byteArray);
        return new Format[]{audioFormat2};
    }

    private byte[] mergeArrays(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        if (byArray2 == null) {
            return byArray;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public void open() {
    }

    public int process(Buffer buffer, Buffer buffer2) {
        int n;
        byte[] byArray = new byte[buffer.getLength()];
        System.arraycopy(buffer.getData(), buffer.getOffset(), byArray, 0, byArray.length);
        byte[] byArray2 = this.mergeArrays((byte[])this.innerBuffer.getData(), byArray);
        this.innerBuffer.setData(byArray2);
        this.innerBuffer.setLength(byArray2.length);
        this.innerDataLength = this.innerBuffer.getLength();
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        byte[] byArray3 = (byte[])buffer2.getData();
        if (byArray3 == null || byArray3.length < 33 * this.innerDataLength / 320) {
            byArray3 = new byte[33 * (this.innerDataLength / 320)];
            buffer2.setData(byArray3);
        }
        if (this.innerDataLength < 320) {
            n = 4;
            System.out.println("Not filled");
        } else {
            boolean bl = ((AudioFormat)this.outputFormat).getEndian() == 1;
            byArray3 = new byte[33 * (this.innerDataLength / 320)];
            buffer2.setData(byArray3);
            buffer2.setLength(33 * (this.innerDataLength / 320));
            GSMEncoderUtil.gsmEncode(bl, (byte[])this.innerBuffer.getData(), this.innerBuffer.getOffset(), this.innerDataLength, byArray3);
            buffer2.setFormat(this.outputFormat);
            buffer2.setData(byArray3);
            n = 0;
            byte[] byArray4 = new byte[this.innerDataLength - this.innerDataLength / 320 * 320];
            this.innerContent = (byte[])this.innerBuffer.getData();
            System.arraycopy(this.innerContent, this.innerDataLength / 320 * 320, byArray4, 0, byArray4.length);
            buffer2.setOffset(0);
            this.innerBuffer.setLength(byArray4.length);
            this.innerBuffer.setData(byArray4);
        }
        return n;
    }

    public Format setInputFormat(Format format) {
        return super.setInputFormat(format);
    }

    public Format setOutputFormat(Format format) {
        return super.setOutputFormat(format);
    }
}

