/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Track;
import net.sf.fmj.utility.LoggerSingleton;

public class TrackInputStream
extends InputStream {
    private static final Logger logger = LoggerSingleton.logger;
    private final Track track;
    private Buffer buffer;

    public TrackInputStream(Track track) {
        this.track = track;
    }

    private void fillBuffer() {
        if (this.buffer == null) {
            this.buffer = new Buffer();
            this.buffer.setFormat(this.track.getFormat());
        }
        do {
            if (this.buffer.isEOM()) {
                return;
            }
            if (this.buffer.getLength() > 0) {
                return;
            }
            this.track.readFrame(this.buffer);
            logger.fine("Read buffer from track: " + this.buffer.getLength());
        } while (this.buffer.isDiscard());
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public int read() throws IOException {
        this.fillBuffer();
        if (this.buffer.getLength() == 0 && this.buffer.isEOM()) {
            return -1;
        }
        byte[] byArray = (byte[])this.buffer.getData();
        int n = byArray[this.buffer.getOffset()] & 0xFF;
        this.buffer.setOffset(this.buffer.getOffset() + 1);
        this.buffer.setLength(this.buffer.getLength() - 1);
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.fillBuffer();
        if (this.buffer.getLength() == 0 && this.buffer.isEOM()) {
            return -1;
        }
        byte[] byArray2 = (byte[])this.buffer.getData();
        int n3 = this.buffer.getLength() < n2 ? this.buffer.getLength() : n2;
        System.arraycopy(byArray2, this.buffer.getOffset(), byArray, n, n3);
        this.buffer.setOffset(this.buffer.getOffset() + n3);
        this.buffer.setLength(this.buffer.getLength() - n3);
        return n3;
    }
}

