/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidateExtendedType;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.ServerReflexiveCandidate;
import org.ice4j.ice.harvest.MappingCandidateHarvester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwsCandidateHarvester
extends MappingCandidateHarvester {
    private static final Logger logger = Logger.getLogger(AwsCandidateHarvester.class.getName());
    private static final String PUBLIC_IP_URL = "http://169.254.169.254/latest/meta-data/public-ipv4";
    private static final String LOCAL_IP_URL = "http://169.254.169.254/latest/meta-data/local-ipv4";
    private static final String EC2_TEST_URL = "http://169.254.169.254/latest/meta-data/";
    private static Boolean RUNNING_ON_EC2 = null;
    private static TransportAddress mask;
    private static TransportAddress face;

    public AwsCandidateHarvester() {
        super(null, null);
    }

    @Override
    public Collection<LocalCandidate> harvest(Component component) {
        if (!(mask != null && face != null || AwsCandidateHarvester.obtainEC2Addresses())) {
            return null;
        }
        HashSet<LocalCandidate> candidates = new HashSet<LocalCandidate>();
        for (Candidate candidate : component.getLocalCandidates()) {
            TransportAddress mappedAddress;
            ServerReflexiveCandidate mappedCandidate;
            if (!(candidate instanceof HostCandidate) || !candidate.getTransportAddress().getHostAddress().equals(face.getHostAddress()) || candidates.contains(mappedCandidate = new ServerReflexiveCandidate(mappedAddress = new TransportAddress(mask.getHostAddress(), candidate.getHostAddress().getPort(), candidate.getHostAddress().getTransport()), (HostCandidate)candidate, candidate.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE)) || !component.addLocalCandidate(mappedCandidate)) continue;
            candidates.add(mappedCandidate);
        }
        return candidates;
    }

    private static synchronized boolean obtainEC2Addresses() {
        if (mask != null && face != null) {
            return true;
        }
        String localIPStr = null;
        String publicIPStr = null;
        try {
            localIPStr = AwsCandidateHarvester.fetch(LOCAL_IP_URL);
            publicIPStr = AwsCandidateHarvester.fetch(PUBLIC_IP_URL);
            face = new TransportAddress(localIPStr, 9, Transport.UDP);
            mask = new TransportAddress(publicIPStr, 9, Transport.UDP);
            logger.info("Detected AWS local IP: " + face);
            logger.info("Detected AWS public IP: " + mask);
        }
        catch (Exception exc) {
            logger.log(Level.INFO, "We failed to obtain EC2 instance addresses for the following reason: ", exc);
            logger.info("String for local IP: " + localIPStr);
            logger.info("String for public IP: " + publicIPStr);
        }
        return true;
    }

    public static TransportAddress getMask() {
        if (AwsCandidateHarvester.smellsLikeAnEC2()) {
            AwsCandidateHarvester.obtainEC2Addresses();
            return mask;
        }
        return null;
    }

    public static TransportAddress getFace() {
        if (AwsCandidateHarvester.smellsLikeAnEC2()) {
            AwsCandidateHarvester.obtainEC2Addresses();
            return face;
        }
        return null;
    }

    public static boolean smellsLikeAnEC2() {
        if (RUNNING_ON_EC2 == null) {
            RUNNING_ON_EC2 = AwsCandidateHarvester.doTestEc2();
        }
        return RUNNING_ON_EC2;
    }

    private static boolean doTestEc2() {
        try {
            URLConnection conn = new URL(EC2_TEST_URL).openConnection();
            conn.setConnectTimeout(500);
            conn.getContent();
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    private static String fetch(String url) throws Exception {
        URLConnection conn = new URL(url).openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        String retString = in.readLine();
        in.close();
        return retString;
    }
}

