/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryListener;
import com.hazelcast.map.impl.DefaultMapServiceContext;
import com.hazelcast.map.impl.EventData;
import com.hazelcast.map.impl.MapEventPublishingService;
import com.hazelcast.map.impl.MapManagedService;
import com.hazelcast.map.impl.MapMigrationAwareService;
import com.hazelcast.map.impl.MapPostJoinAwareService;
import com.hazelcast.map.impl.MapRemoteService;
import com.hazelcast.map.impl.MapReplicationSupportingService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MapSplitBrainHandlerService;
import com.hazelcast.map.impl.MapTransactionalService;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.PostJoinAwareService;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.ReplicationSupportingService;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.spi.TransactionalService;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.wan.WanReplicationEvent;
import java.util.Properties;

public final class MapService
implements ManagedService,
MigrationAwareService,
TransactionalService,
RemoteService,
EventPublishingService<EventData, EntryListener>,
PostJoinAwareService,
SplitBrainHandlerService,
ReplicationSupportingService {
    public static final String SERVICE_NAME = "hz:impl:mapService";
    private ManagedService managedService;
    private MigrationAwareService migrationAwareService;
    private TransactionalService transactionalService;
    private RemoteService remoteService;
    private EventPublishingService eventPublishingService;
    private PostJoinAwareService postJoinAwareService;
    private SplitBrainHandlerService splitBrainHandlerService;
    private ReplicationSupportingService replicationSupportingService;
    private MapServiceContext mapServiceContext;

    private MapService() {
    }

    @Override
    public void dispatchEvent(EventData event, EntryListener listener) {
        this.eventPublishingService.dispatchEvent(event, listener);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.managedService.init(nodeEngine, properties);
    }

    @Override
    public void reset() {
        this.managedService.reset();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.managedService.shutdown(terminate);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        return this.migrationAwareService.prepareReplicationOperation(event);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.beforeMigration(event);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.commitMigration(event);
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        this.migrationAwareService.rollbackMigration(event);
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.migrationAwareService.clearPartitionReplica(partitionId);
    }

    @Override
    public Operation getPostJoinOperation() {
        return this.postJoinAwareService.getPostJoinOperation();
    }

    @Override
    public DistributedObject createDistributedObject(String objectName) {
        return this.remoteService.createDistributedObject(objectName);
    }

    @Override
    public void destroyDistributedObject(String objectName) {
        this.remoteService.destroyDistributedObject(objectName);
    }

    @Override
    public void onReplicationEvent(WanReplicationEvent replicationEvent) {
        this.replicationSupportingService.onReplicationEvent(replicationEvent);
    }

    @Override
    public Runnable prepareMergeRunnable() {
        return this.splitBrainHandlerService.prepareMergeRunnable();
    }

    @Override
    public <T extends TransactionalObject> T createTransactionalObject(String name, TransactionSupport transaction) {
        return this.transactionalService.createTransactionalObject(name, transaction);
    }

    @Override
    public void rollbackTransaction(String transactionId) {
        this.transactionalService.rollbackTransaction(transactionId);
    }

    public void setMapServiceContext(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
    }

    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    public static MapService create(NodeEngine nodeEngine) {
        DefaultMapServiceContext mapServiceContext = new DefaultMapServiceContext(nodeEngine);
        MapManagedService managedService = new MapManagedService(mapServiceContext);
        MapMigrationAwareService migrationAwareService = new MapMigrationAwareService(mapServiceContext);
        MapTransactionalService transactionalService = new MapTransactionalService(mapServiceContext);
        MapRemoteService remoteService = new MapRemoteService(mapServiceContext);
        MapEventPublishingService eventPublisher = new MapEventPublishingService(mapServiceContext);
        MapPostJoinAwareService postJoinAwareService = new MapPostJoinAwareService(mapServiceContext);
        MapSplitBrainHandlerService splitBrainHandler = new MapSplitBrainHandlerService(mapServiceContext);
        MapReplicationSupportingService replicationSupportingService = new MapReplicationSupportingService(mapServiceContext);
        MapService mapService = new MapService();
        mapService.setManagedService(managedService);
        mapService.setMigrationAwareService(migrationAwareService);
        mapService.setTransactionalService(transactionalService);
        mapService.setRemoteService(remoteService);
        mapService.setEventPublishingService(eventPublisher);
        mapService.setPostJoinAwareService(postJoinAwareService);
        mapService.setSplitBrainHandlerService(splitBrainHandler);
        mapService.setReplicationSupportingService(replicationSupportingService);
        mapService.setMapServiceContext(mapServiceContext);
        mapServiceContext.setService(mapService);
        return mapService;
    }

    void setManagedService(ManagedService managedService) {
        this.managedService = managedService;
    }

    void setMigrationAwareService(MigrationAwareService migrationAwareService) {
        this.migrationAwareService = migrationAwareService;
    }

    void setTransactionalService(TransactionalService transactionalService) {
        this.transactionalService = transactionalService;
    }

    void setRemoteService(RemoteService remoteService) {
        this.remoteService = remoteService;
    }

    void setEventPublishingService(EventPublishingService eventPublishingService) {
        this.eventPublishingService = eventPublishingService;
    }

    void setPostJoinAwareService(PostJoinAwareService postJoinAwareService) {
        this.postJoinAwareService = postJoinAwareService;
    }

    void setSplitBrainHandlerService(SplitBrainHandlerService splitBrainHandlerService) {
        this.splitBrainHandlerService = splitBrainHandlerService;
    }

    void setReplicationSupportingService(ReplicationSupportingService replicationSupportingService) {
        this.replicationSupportingService = replicationSupportingService;
    }
}

