/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.ssi.ActivateSsiCmd;
import net.kano.joscar.snaccmd.ssi.CreateItemsCmd;
import net.kano.joscar.snaccmd.ssi.DeleteItemsCmd;
import net.kano.joscar.snaccmd.ssi.ModifyItemsCmd;
import net.kano.joscar.snaccmd.ssi.PostModCmd;
import net.kano.joscar.snaccmd.ssi.PreModCmd;
import net.kano.joscar.snaccmd.ssi.SsiDataCheck;
import net.kano.joscar.snaccmd.ssi.SsiDataRequest;
import net.kano.joscar.snaccmd.ssi.SsiRightsRequest;

public class ServerSsiCmdFactory
implements SnacCmdFactory {
    private static final CmdType[] SUPPORTED_TYPES = new CmdType[]{new CmdType(19, 2), new CmdType(19, 4), new CmdType(19, 5), new CmdType(19, 7), new CmdType(19, 8), new CmdType(19, 9), new CmdType(19, 10), new CmdType(19, 17), new CmdType(19, 18)};

    public CmdType[] getSupportedTypes() {
        return (CmdType[])SUPPORTED_TYPES.clone();
    }

    public SnacCommand genSnacCommand(SnacPacket snacPacket) {
        if (snacPacket.getFamily() != 19) {
            return null;
        }
        int n = snacPacket.getCommand();
        if (n == 2) {
            return new SsiRightsRequest(snacPacket);
        }
        if (n == 4) {
            return new SsiDataRequest(snacPacket);
        }
        if (n == 5) {
            return new SsiDataCheck(snacPacket);
        }
        if (n == 7) {
            return new ActivateSsiCmd(snacPacket);
        }
        if (n == 8) {
            return new CreateItemsCmd(snacPacket);
        }
        if (n == 9) {
            return new ModifyItemsCmd(snacPacket);
        }
        if (n == 10) {
            return new DeleteItemsCmd(snacPacket);
        }
        if (n == 17) {
            return new PreModCmd(snacPacket);
        }
        if (n == 18) {
            return new PostModCmd(snacPacket);
        }
        return null;
    }
}

