/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.txn;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.multimap.impl.MultiMapContainer;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.MultiMapService;
import com.hazelcast.multimap.impl.MultiMapWrapper;
import com.hazelcast.multimap.impl.operations.MultiMapKeyBasedOperation;
import com.hazelcast.multimap.impl.txn.TxnRemoveBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class TxnRemoveOperation
extends MultiMapKeyBasedOperation
implements BackupAwareOperation {
    long recordId;
    Data value;
    long begin = -1L;

    public TxnRemoveOperation() {
    }

    public TxnRemoveOperation(String name, Data dataKey, long recordId, Data value) {
        super(name, dataKey);
        this.recordId = recordId;
        this.value = value;
    }

    @Override
    public void run() throws Exception {
        this.begin = Clock.currentTimeMillis();
        MultiMapContainer container = this.getOrCreateContainer();
        MultiMapWrapper wrapper = container.getMultiMapWrapperOrNull(this.dataKey);
        this.response = true;
        if (wrapper == null || !wrapper.containsRecordId(this.recordId)) {
            this.response = false;
            return;
        }
        Collection<MultiMapRecord> coll = wrapper.getCollection(false);
        Iterator<MultiMapRecord> iter = coll.iterator();
        while (iter.hasNext()) {
            if (iter.next().getRecordId() != this.recordId) continue;
            iter.remove();
            break;
        }
        if (coll.isEmpty()) {
            this.delete();
        }
    }

    @Override
    public void afterRun() throws Exception {
        long elapsed = Math.max(0L, Clock.currentTimeMillis() - this.begin);
        MultiMapService service = (MultiMapService)this.getService();
        service.getLocalMultiMapStatsImpl(this.name).incrementRemoves(elapsed);
        if (Boolean.TRUE.equals(this.response)) {
            this.getOrCreateContainer().update();
            this.publishEvent(EntryEventType.REMOVED, this.dataKey, null, this.value);
        }
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public Operation getBackupOperation() {
        return new TxnRemoveBackupOperation(this.name, this.dataKey, this.recordId, this.value);
    }

    public long getRecordId() {
        return this.recordId;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.recordId);
        out.writeData(this.value);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.recordId = in.readLong();
        this.value = in.readData();
    }

    @Override
    public int getId() {
        return 35;
    }
}

