/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.utility.LoggerSingleton;

public class GsmParser
extends AbstractDemultiplexer {
    private static double GSM_FRAME_RATE = 50.0;
    private static final Logger logger = LoggerSingleton.logger;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("audio.x_gsm")};
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;

    private static final double secondsToNanos(double d) {
        return d * 1.0E9;
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public boolean isPositionable() {
        return true;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    public Time setPosition(Time time, int n) {
        return null;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (!(dataSource instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)dataSource;
    }

    public void start() throws IOException {
        this.source.start();
        PullSourceStream[] pullSourceStreamArray = this.source.getStreams();
        this.tracks = new PullSourceStreamTrack[pullSourceStreamArray.length];
        for (int i = 0; i < pullSourceStreamArray.length; ++i) {
            this.tracks[i] = new PullSourceStreamTrack(pullSourceStreamArray[i]);
        }
    }

    public void stop() {
        try {
            this.source.stop();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "" + iOException, iOException);
        }
    }

    private class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStream stream;
        private long frameLength;
        private static final int GSM_FRAME_SIZE = 33;

        public PullSourceStreamTrack(PullSourceStream pullSourceStream) {
            this.stream = pullSourceStream;
            this.frameLength = pullSourceStream.getContentLength() / 33L;
        }

        public Time getDuration() {
            long l = this.frameLength;
            if (l < 0L) {
                logger.fine("PullSourceStreamTrack: returning Duration.DURATION_UNKNOWN (1)");
                return Duration.DURATION_UNKNOWN;
            }
            double d = (double)l / GSM_FRAME_RATE;
            if (d < 0.0) {
                logger.fine("PullSourceStreamTrack: returning Duration.DURATION_UNKNOWN (2)");
                return Duration.DURATION_UNKNOWN;
            }
            double d2 = GsmParser.secondsToNanos(d);
            logger.fine("PullSourceStreamTrack: returning " + (long)d2);
            return new Time((long)d2);
        }

        public Format getFormat() {
            return new AudioFormat("gsm", 8000.0, 8, 1, -1, 1, 264, -1.0, Format.byteArray);
        }

        public void readFrame(Buffer buffer) {
            if (buffer.getData() == null) {
                buffer.setData(new byte[16500]);
            }
            byte[] byArray = (byte[])buffer.getData();
            try {
                int n = this.stream.read(byArray, 0, byArray.length);
                if (n < 0) {
                    buffer.setEOM(true);
                    buffer.setLength(0);
                    return;
                }
                buffer.setLength(n);
                buffer.setOffset(0);
            }
            catch (IOException iOException) {
                buffer.setEOM(true);
                buffer.setDiscard(true);
                buffer.setLength(0);
                logger.log(Level.WARNING, "" + iOException, iOException);
            }
        }
    }
}

