/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.BufferQueueInputStream;
import net.sf.fmj.media.renderer.audio.JavaSoundUtils;
import net.sf.fmj.utility.FormatUtils;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.LoggingStringUtils;

public class JavaSoundCodec
extends AbstractCodec {
    private static final Logger logger = LoggerSingleton.logger;
    private BufferQueueInputStream bufferQueueInputStream;
    private volatile AudioInputStream audioInputStream;
    private volatile AudioInputStream audioInputStreamConverted;
    private AudioInputStreamThread audioInputStreamThread;
    private boolean trace;
    private int totalIn;
    private int totalOut;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_LONG = 8;
    private static final int SIZEOF_SHORT = 2;
    private static final int BITS_PER_BYTE = 8;
    private static final int MAX_SIGNED_BYTE = 127;
    private static final int MAX_BYTE = 255;
    private static final int MAX_BYTE_PLUS1 = 256;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] createAuHeader(javax.sound.sampled.AudioFormat audioFormat) {
        int n;
        byte[] byArray = new byte[24];
        JavaSoundCodec.encodeIntBE(779316836, byArray, 0);
        JavaSoundCodec.encodeIntBE(byArray.length, byArray, 4);
        JavaSoundCodec.encodeIntBE(-1, byArray, 8);
        if (audioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
            if (audioFormat.getSampleSizeInBits() != 8) return null;
            n = 27;
        } else if (audioFormat.getEncoding() == AudioFormat.Encoding.ULAW) {
            if (audioFormat.getSampleSizeInBits() != 8) return null;
            n = 1;
        } else if (audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                n = 2;
            } else if (audioFormat.getSampleSizeInBits() == 16) {
                n = 3;
            } else if (audioFormat.getSampleSizeInBits() == 24) {
                n = 4;
            } else {
                if (audioFormat.getSampleSizeInBits() != 32) return null;
                n = 5;
            }
            if (audioFormat.getSampleSizeInBits() > 8 && !audioFormat.isBigEndian()) {
                return null;
            }
        } else {
            if (audioFormat.getEncoding() != AudioFormat.Encoding.PCM_UNSIGNED) return null;
            return null;
        }
        JavaSoundCodec.encodeIntBE(n, byArray, 12);
        if (audioFormat.getSampleRate() < 0.0f) {
            return null;
        }
        JavaSoundCodec.encodeIntBE((int)audioFormat.getSampleRate(), byArray, 16);
        if (audioFormat.getChannels() < 0) {
            return null;
        }
        JavaSoundCodec.encodeIntBE(audioFormat.getChannels(), byArray, 20);
        return byArray;
    }

    public static byte[] createWavHeader(javax.sound.sampled.AudioFormat audioFormat) {
        if (audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED && audioFormat.getEncoding() != AudioFormat.Encoding.PCM_UNSIGNED) {
            return null;
        }
        if (audioFormat.getSampleSizeInBits() == 8 && audioFormat.getEncoding() != AudioFormat.Encoding.PCM_UNSIGNED) {
            return null;
        }
        if (audioFormat.getSampleSizeInBits() == 16 && audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            return null;
        }
        byte[] byArray = new byte[44];
        if (audioFormat.getSampleSizeInBits() > 8 && audioFormat.isBigEndian()) {
            JavaSoundCodec.encodeIntBE(1380533848, byArray, 0);
        } else {
            JavaSoundCodec.encodeIntBE(1380533830, byArray, 0);
        }
        int n = Integer.MAX_VALUE;
        JavaSoundCodec.encodeIntLE(n + byArray.length - 8, byArray, 4);
        JavaSoundCodec.encodeIntBE(1463899717, byArray, 8);
        JavaSoundCodec.encodeIntBE(1718449184, byArray, 12);
        JavaSoundCodec.encodeIntLE(16, byArray, 16);
        JavaSoundCodec.encodeShortLE((short)1, byArray, 20);
        JavaSoundCodec.encodeShortLE((short)audioFormat.getChannels(), byArray, 22);
        JavaSoundCodec.encodeIntLE((int)audioFormat.getSampleRate(), byArray, 24);
        JavaSoundCodec.encodeIntLE((int)audioFormat.getSampleRate() * audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8, byArray, 28);
        JavaSoundCodec.encodeShortLE((short)(audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8), byArray, 32);
        JavaSoundCodec.encodeShortLE((short)audioFormat.getSampleSizeInBits(), byArray, 34);
        JavaSoundCodec.encodeIntBE(1684108385, byArray, 36);
        JavaSoundCodec.encodeIntLE(n, byArray, 40);
        return byArray;
    }

    private static void encodeIntBE(int n, byte[] byArray, int n2) {
        int n3 = 4;
        for (int i = 0; i < n3; ++i) {
            int n4 = n & 0xFF;
            if (n4 > 127) {
                n4 -= 256;
            }
            byArray[n2 + (n3 - i - 1)] = (byte)n4;
            n >>= 8;
        }
    }

    private static void encodeIntLE(int n, byte[] byArray, int n2) {
        int n3 = 4;
        for (int i = 0; i < n3; ++i) {
            int n4 = n & 0xFF;
            if (n4 > 127) {
                n4 -= 256;
            }
            byArray[n2 + i] = (byte)n4;
            n >>= 8;
        }
    }

    public static void encodeShortBE(short s, byte[] byArray, int n) {
        int n2 = 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = s & 0xFF;
            if (n3 > 127) {
                n3 -= 256;
            }
            byArray[n + (n2 - i - 1)] = (byte)n3;
            s = (short)(s >> 8);
        }
    }

    public static void encodeShortLE(short s, byte[] byArray, int n) {
        int n2 = 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = s & 0xFF;
            if (n3 > 127) {
                n3 -= 256;
            }
            byArray[n + i] = (byte)n3;
            s = (short)(s >> 8);
        }
    }

    private static byte[] fakeHeader(javax.sound.sampled.AudioFormat audioFormat) {
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        if (!JavaSoundUtils.onlyStandardFormats) {
            try {
                clazz2 = Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFormat");
                clazz = Class.forName("javazoom.spi.vorbis.sampled.file.VorbisAudioFormat");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != clazz2 && clazz2.isInstance(audioFormat)) {
            return new byte[0];
        }
        if (null != clazz && clazz.isInstance(audioFormat)) {
            return new byte[0];
        }
        byte[] byArray = JavaSoundCodec.createAuHeader(audioFormat);
        if (byArray != null) {
            return byArray;
        }
        byArray = JavaSoundCodec.createWavHeader(audioFormat);
        if (byArray != null) {
            return byArray;
        }
        return null;
    }

    public JavaSoundCodec() {
        Vector<AudioFormat> vector = new Vector<AudioFormat>();
        vector.add(new AudioFormat("ULAW"));
        vector.add(new AudioFormat("alaw"));
        vector.add(new AudioFormat("LINEAR"));
        if (!JavaSoundUtils.onlyStandardFormats) {
            int n;
            String[] stringArray;
            Class<?> clazz;
            try {
                clazz = Class.forName("javazoom.spi.mpeg.sampled.file.MpegEncoding");
                stringArray = new String[]{"MPEG1L1", "MPEG1L2", "MPEG1L3", "MPEG2DOT5L1", "MPEG2DOT5L2", "MPEG2DOT5L3", "MPEG2L1", "MPEG2L2", "MPEG2L3"};
                for (n = 0; n < stringArray.length; ++n) {
                    vector.add(new AudioFormat(stringArray[n]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                clazz = Class.forName("javazoom.spi.vorbis.sampled.file.VorbisEncoding");
                stringArray = new String[]{"VORBISENC"};
                for (n = 0; n < stringArray.length; ++n) {
                    vector.add(new AudioFormat(stringArray[n]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.inputFormats = new Format[vector.size()];
        vector.toArray(this.inputFormats);
    }

    public Format[] getSupportedOutputFormats(Format format) {
        int n;
        javax.sound.sampled.AudioFormat[] audioFormatArray;
        Format[] formatArray;
        if (format == null) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        javax.sound.sampled.AudioFormat audioFormat = JavaSoundUtils.convertFormat((AudioFormat)format);
        javax.sound.sampled.AudioFormat[] audioFormatArray2 = AudioSystem.getTargetFormats(AudioFormat.Encoding.PCM_UNSIGNED, audioFormat);
        javax.sound.sampled.AudioFormat[] audioFormatArray3 = AudioSystem.getTargetFormats(AudioFormat.Encoding.PCM_SIGNED, audioFormat);
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        if (!JavaSoundUtils.onlyStandardFormats) {
            try {
                clazz2 = Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFormat");
                clazz = Class.forName("javazoom.spi.vorbis.sampled.file.VorbisAudioFormat");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != clazz2 && clazz2.isInstance(audioFormat)) {
            formatArray = new javax.sound.sampled.AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
            audioFormatArray = new javax.sound.sampled.AudioFormat[]{formatArray};
        } else if (null != clazz && clazz.isInstance(audioFormat)) {
            formatArray = new javax.sound.sampled.AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
            audioFormatArray = new javax.sound.sampled.AudioFormat[]{formatArray};
        } else {
            audioFormatArray = new javax.sound.sampled.AudioFormat[]{};
        }
        formatArray = new Format[audioFormatArray2.length + audioFormatArray3.length + audioFormatArray.length];
        for (n = 0; n < audioFormatArray2.length; ++n) {
            formatArray[n] = JavaSoundUtils.convertFormat(audioFormatArray2[n]);
            logger.finer("getSupportedOutputFormats: " + formatArray[n]);
        }
        for (n = 0; n < audioFormatArray3.length; ++n) {
            formatArray[audioFormatArray2.length + n] = JavaSoundUtils.convertFormat(audioFormatArray3[n]);
            logger.finer("getSupportedOutputFormats: " + formatArray[audioFormatArray2.length + n]);
        }
        for (n = 0; n < audioFormatArray.length; ++n) {
            formatArray[audioFormatArray2.length + audioFormatArray3.length + n] = JavaSoundUtils.convertFormat(audioFormatArray[n]);
            logger.finer("getSupportedOutputFormats: " + formatArray[audioFormatArray2.length + audioFormatArray3.length + n]);
        }
        for (n = 0; n < formatArray.length; ++n) {
            AudioFormat audioFormat2 = (AudioFormat)formatArray[n];
            AudioFormat audioFormat3 = (AudioFormat)format;
            if (!FormatUtils.specified(audioFormat3.getSampleRate()) || FormatUtils.specified(audioFormat2.getSampleRate())) continue;
            formatArray[n] = null;
        }
        return formatArray;
    }

    public void open() throws ResourceUnavailableException {
        super.open();
        this.bufferQueueInputStream = new BufferQueueInputStream();
        javax.sound.sampled.AudioFormat audioFormat = JavaSoundUtils.convertFormat((AudioFormat)this.inputFormat);
        logger.fine("javaSoundAudioFormat converted (in)=" + audioFormat);
        byte[] byArray = JavaSoundCodec.fakeHeader(audioFormat);
        if (byArray == null) {
            throw new ResourceUnavailableException("Unable to reconstruct header for format: " + this.inputFormat);
        }
        if (byArray.length > 0) {
            Buffer buffer = new Buffer();
            buffer.setData(byArray);
            buffer.setLength(byArray.length);
            this.bufferQueueInputStream.put(buffer);
        }
        this.audioInputStreamThread = new AudioInputStreamThread(this.bufferQueueInputStream);
        this.audioInputStreamThread.start();
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        try {
            int n;
            boolean bl;
            if (this.trace) {
                logger.fine("process: " + LoggingStringUtils.bufferToStr(buffer));
            }
            this.totalIn += buffer.getLength();
            boolean bl2 = bl = !this.bufferQueueInputStream.put(buffer);
            if (this.audioInputStreamConverted == null) {
                if (bl) {
                    logger.fine("JavaSoundCodec: audioInputStreamConverted == null, blocking until not null");
                    try {
                        while (this.audioInputStreamConverted == null) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return 1;
                    }
                } else {
                    logger.fine("JavaSoundCodec: audioInputStreamConverted == null, returning OUTPUT_BUFFER_NOT_FILLED");
                    buffer2.setLength(0);
                    return 4;
                }
            }
            int n2 = this.audioInputStreamConverted.available();
            if (this.trace) {
                logger.fine("audioInputStreamConverted.available() == " + n2 + ", bufferQueueInputStream.available() = " + this.bufferQueueInputStream.available());
            }
            if (buffer2.getData() == null) {
                buffer2.setData(new byte[10000]);
            }
            buffer2.setFormat(this.getOutputFormat());
            byte[] byArray = (byte[])buffer2.getData();
            if (bl || buffer.isEOM()) {
                n = byArray.length;
            } else {
                int n3 = n = n2 > byArray.length ? byArray.length : n2;
            }
            if (n == 0) {
                logger.finer("JavaSoundCodec: lenToRead == 0, returning OUTPUT_BUFFER_NOT_FILLED.  input.isEOM()=" + buffer.isEOM());
                buffer2.setLength(0);
                return 4;
            }
            int n4 = this.audioInputStreamConverted.read(byArray, 0, n);
            logger.finer("JavaSoundCodec: Read from audioInputStreamConverted: " + n4);
            if (n4 == -1) {
                logger.fine("total in: " + this.totalIn + " total out: " + this.totalOut);
                buffer2.setEOM(true);
                buffer2.setLength(0);
                return 0;
            }
            buffer2.setLength(n4);
            this.totalOut += n4;
            return bl || buffer.isEOM() ? 2 : 0;
        }
        catch (IOException iOException) {
            buffer2.setLength(0);
            return 1;
        }
    }

    void setTrace(boolean bl) {
        this.trace = bl;
    }

    private class AudioInputStreamThread
    extends Thread {
        private final BufferQueueInputStream bufferQueueInputStream;

        public AudioInputStreamThread(BufferQueueInputStream bufferQueueInputStream) {
            this.bufferQueueInputStream = bufferQueueInputStream;
        }

        public void run() {
            try {
                JavaSoundCodec.this.audioInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(this.bufferQueueInputStream));
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                logger.log(Level.WARNING, "" + unsupportedAudioFileException, unsupportedAudioFileException);
                return;
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "" + iOException, iOException);
                return;
            }
            javax.sound.sampled.AudioFormat audioFormat = JavaSoundUtils.convertFormat((AudioFormat)JavaSoundCodec.this.outputFormat);
            logger.fine("javaSoundAudioFormat converted (out)=" + audioFormat);
            JavaSoundCodec.this.audioInputStreamConverted = AudioSystem.getAudioInputStream(audioFormat, JavaSoundCodec.this.audioInputStream);
        }
    }
}

