/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.transform;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtcp.NACKPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.RtpChannel;

public class RetransmissionRequester
extends SinglePacketTransformer
implements TransformEngine {
    private static final int MAX_MISSING = 30;
    private static final int MAX_REQUESTS = 10;
    private static final int RE_REQUEST_AFTER = 150;
    private static final Logger logger = Logger.getLogger(RetransmissionRequester.class);
    private final Map<Long, Requester> requesters = new HashMap<Long, Requester>();
    private final RtpChannel channel;
    private final Thread thread;
    private boolean closed = false;

    private static int diff(int a, int b) {
        int diff = a - b;
        if (diff < Short.MIN_VALUE) {
            diff += 65536;
        } else if (diff > 32768) {
            diff -= 65536;
        }
        return diff;
    }

    RetransmissionRequester(RtpChannel channel) {
        this.channel = channel;
        this.thread = new Thread(){

            public void run() {
                RetransmissionRequester.this.runInRequesterThread();
            }
        };
        this.thread.setDaemon(true);
        this.thread.setName(RetransmissionRequester.class.getName());
        this.thread.start();
    }

    public RawPacket transform(RawPacket pkt) {
        return pkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawPacket reverseTransform(RawPacket pkt) {
        Requester requester;
        long ssrc = (long)pkt.getSSRC() & 0xFFFFFFFFL;
        Map<Long, Requester> map = this.requesters;
        synchronized (map) {
            requester = this.requesters.get(ssrc);
            if (requester == null) {
                requester = new Requester(ssrc);
                this.requesters.put(ssrc, requester);
            }
        }
        requester.received(pkt.getSequenceNumber());
        return pkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInRequesterThread() {
        if (Thread.currentThread() != this.thread) {
            return;
        }
        HashMap<Long, Set> packetsToRequest = new HashMap<Long, Set>();
        while (!this.closed) {
            Object object = this.thread;
            synchronized (object) {
                long nextRequestAt = -1L;
                Map<Long, Requester> map = this.requesters;
                synchronized (map) {
                    for (Requester requester : this.requesters.values()) {
                        if (requester.nextRequestAt == -1L || nextRequestAt != -1L && nextRequestAt <= requester.nextRequestAt) continue;
                        nextRequestAt = requester.nextRequestAt;
                    }
                }
                long now = System.currentTimeMillis();
                if (nextRequestAt == -1L || nextRequestAt - now > 0L) {
                    try {
                        if (nextRequestAt == -1L) {
                            this.thread.wait();
                        } else {
                            this.thread.wait(nextRequestAt - now);
                        }
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
            object = this.requesters;
            synchronized (object) {
                for (Map.Entry<Long, Requester> entry : this.requesters.entrySet()) {
                    Requester requester = entry.getValue();
                    Set missingPackets = requester.getMissing();
                    if (missingPackets == null || missingPackets.isEmpty()) continue;
                    packetsToRequest.put(requester.ssrc, missingPackets);
                }
            }
            MediaStream mediaStream = this.channel.getStream();
            if (mediaStream != null) {
                long senderSsrc = this.channel.getContent().getInitialLocalSSRC();
                for (Map.Entry entry : packetsToRequest.entrySet()) {
                    long sourceSsrc = (Long)entry.getKey();
                    NACKPacket nack = new NACKPacket(senderSsrc, sourceSsrc, (Collection)entry.getValue());
                    RawPacket pkt = null;
                    try {
                        pkt = nack.toRawPacket();
                    }
                    catch (IOException ioe) {
                        logger.warn((Object)("Failed to create a NACK packet: " + ioe));
                    }
                    if (pkt == null) continue;
                    mediaStream.injectPacket(pkt, false, true);
                }
            }
            packetsToRequest.clear();
        }
    }

    public PacketTransformer getRTPTransformer() {
        return this;
    }

    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    private class Request {
        private int seq;
        private long firstRequestSentAt = -1L;
        private int timesRequested = 0;

        private Request(int seq) {
            this.seq = seq;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Requester {
        private final long ssrc;
        private int lastReceivedSeq = -1;
        private long nextRequestAt = -1L;
        private final Map<Integer, Request> requests = new HashMap<Integer, Request>();

        private Requester(long ssrc) {
            this.ssrc = ssrc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void received(int seq) {
            if (this.lastReceivedSeq == -1) {
                this.lastReceivedSeq = seq;
                return;
            }
            int diff = RetransmissionRequester.diff(seq, this.lastReceivedSeq);
            if (diff <= 0) {
                this.requests.remove(seq);
            } else if (diff == 1) {
                this.lastReceivedSeq = seq;
            } else if (diff <= 30) {
                int missing = (this.lastReceivedSeq + 1) % 65536;
                while (missing != seq) {
                    Request request = new Request(missing);
                    this.requests.put(missing, request);
                    missing = (missing + 1) % 65536;
                }
                this.lastReceivedSeq = seq;
                this.nextRequestAt = 0L;
                Thread thread = RetransmissionRequester.this.thread;
                synchronized (thread) {
                    RetransmissionRequester.this.thread.notifyAll();
                }
            } else {
                this.lastReceivedSeq = seq;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resetting retransmission requester state. SSRC: " + this.ssrc + ", last received: " + this.lastReceivedSeq + ", current: " + seq + ". Removing " + this.requests.size() + " unsatisfied requests."));
                }
                this.requests.clear();
                this.nextRequestAt = -1L;
            }
        }

        private synchronized Set<Integer> getMissing() {
            long now = System.currentTimeMillis();
            HashSet<Integer> missingPackets = null;
            if (this.nextRequestAt == -1L || this.nextRequestAt > now) {
                return null;
            }
            Iterator<Map.Entry<Integer, Request>> iter = this.requests.entrySet().iterator();
            while (iter.hasNext()) {
                Request request = iter.next().getValue();
                if (missingPackets == null) {
                    missingPackets = new HashSet<Integer>();
                }
                missingPackets.add(request.seq);
                request.timesRequested++;
                if (request.timesRequested == 1) {
                    request.firstRequestSentAt = now;
                    continue;
                }
                if (request.timesRequested != 10) continue;
                logger.info((Object)("Sending the last NACK for SSRC=" + this.ssrc + " seq=" + request.seq + ". " + "Time since the first request: " + (now - request.firstRequestSentAt)));
                iter.remove();
            }
            this.nextRequestAt = this.requests.size() > 0 ? now + 150L : -1L;
            return missingPackets;
        }
    }
}

