/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.video4linux2;

import java.io.IOException;
import javax.media.MediaLocator;
import javax.media.control.FormatControl;
import javax.media.protocol.PullBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractVideoPullBufferCaptureDevice;
import org.jitsi.impl.neomedia.jmfext.media.protocol.video4linux2.Video4Linux2;
import org.jitsi.impl.neomedia.jmfext.media.protocol.video4linux2.Video4Linux2Stream;

public class DataSource
extends AbstractVideoPullBufferCaptureDevice {
    private static final int[] V4L2_TO_FFMPEG_PIX_FMT = new int[]{Video4Linux2.V4L2_PIX_FMT_UYVY, 17, Video4Linux2.V4L2_PIX_FMT_YUV420, 0, Video4Linux2.V4L2_PIX_FMT_YUYV, 1, Video4Linux2.V4L2_PIX_FMT_MJPEG, 13, Video4Linux2.V4L2_PIX_FMT_JPEG, 13, Video4Linux2.V4L2_PIX_FMT_RGB24, 2, Video4Linux2.V4L2_PIX_FMT_BGR24, 3};
    private int fd = -1;

    public DataSource() {
    }

    public DataSource(MediaLocator locator) {
        super(locator);
    }

    protected Video4Linux2Stream createStream(int streamIndex, FormatControl formatControl) {
        return new Video4Linux2Stream(this, formatControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doConnect() throws IOException {
        super.doConnect();
        String deviceName = this.getDeviceName();
        int fd = Video4Linux2.open(deviceName, 2);
        if (-1 == fd) {
            throw new IOException("Failed to open " + deviceName);
        }
        boolean close = true;
        try {
            Object object = this.getStreamSyncRoot();
            synchronized (object) {
                for (PullBufferStream stream : this.getStreams()) {
                    ((Video4Linux2Stream)stream).setFd(fd);
                }
            }
            close = false;
        }
        finally {
            if (close) {
                Video4Linux2.close(fd);
                fd = -1;
            }
        }
        this.fd = fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDisconnect() {
        try {
            Object object = this.getStreamSyncRoot();
            synchronized (object) {
                AbstractBufferStream<?>[] streams = this.streams();
                if (streams != null) {
                    for (AbstractBufferStream<?> stream : streams) {
                        try {
                            ((Video4Linux2Stream)stream).setFd(-1);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        finally {
            try {
                super.doDisconnect();
            }
            finally {
                Video4Linux2.close(this.fd);
            }
        }
    }

    private String getDeviceName() {
        MediaLocator locator = this.getLocator();
        return locator != null && "video4linux2".equalsIgnoreCase(locator.getProtocol()) ? locator.getRemainder() : null;
    }

    public static int getFFmpegPixFmt(int v4l2PixFmt) {
        for (int i = 0; i < V4L2_TO_FFMPEG_PIX_FMT.length; i += 2) {
            if (V4L2_TO_FFMPEG_PIX_FMT[i] != v4l2PixFmt) continue;
            return V4L2_TO_FFMPEG_PIX_FMT[i + 1];
        }
        return -1;
    }

    public static int getV4L2PixFmt(int ffmpegPixFmt) {
        for (int i = 0; i < V4L2_TO_FFMPEG_PIX_FMT.length; i += 2) {
            if (V4L2_TO_FFMPEG_PIX_FMT[i + 1] != ffmpegPixFmt) continue;
            return V4L2_TO_FFMPEG_PIX_FMT[i];
        }
        return 0;
    }
}

