/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.commands;

import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.Mode;
import f00f.net.irc.martyr.clientstate.Channel;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.ModeCommand;
import f00f.net.irc.martyr.modes.channel.AnonChannelMode;
import f00f.net.irc.martyr.modes.channel.BanMode;
import f00f.net.irc.martyr.modes.channel.ExceptionMode;
import f00f.net.irc.martyr.modes.channel.InviteMaskMode;
import f00f.net.irc.martyr.modes.channel.InviteOnlyMode;
import f00f.net.irc.martyr.modes.channel.KeyMode;
import f00f.net.irc.martyr.modes.channel.LimitMode;
import f00f.net.irc.martyr.modes.channel.ModeratedMode;
import f00f.net.irc.martyr.modes.channel.NoExtMsgMode;
import f00f.net.irc.martyr.modes.channel.OperMode;
import f00f.net.irc.martyr.modes.channel.PrivateMode;
import f00f.net.irc.martyr.modes.channel.SecretMode;
import f00f.net.irc.martyr.modes.channel.TopicLockMode;
import f00f.net.irc.martyr.modes.channel.VoiceMode;
import f00f.net.irc.martyr.util.FullNick;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class ChannelModeCommand
extends ModeCommand {
    private String prefix;
    private String channelName;
    private FullNick sender;
    private List modes;
    private static HashMap<Character, Mode> modeTypes;

    public ChannelModeCommand(String prefix, String channelName, StringTokenizer params) {
        this.makeModes();
        this.prefix = prefix;
        this.channelName = channelName;
        this.modes = this.parseModes(modeTypes, params);
    }

    public ChannelModeCommand(String channelName) {
        this.sender = null;
        this.channelName = channelName;
        this.modes = new LinkedList();
    }

    public void makeModes() {
        if (modeTypes == null) {
            modeTypes = new HashMap();
            ChannelModeCommand.registerMode(modeTypes, new BanMode());
            ChannelModeCommand.registerMode(modeTypes, new KeyMode());
            ChannelModeCommand.registerMode(modeTypes, new OperMode());
            ChannelModeCommand.registerMode(modeTypes, new VoiceMode());
            ChannelModeCommand.registerMode(modeTypes, new LimitMode());
            ChannelModeCommand.registerMode(modeTypes, new SecretMode());
            ChannelModeCommand.registerMode(modeTypes, new PrivateMode());
            ChannelModeCommand.registerMode(modeTypes, new NoExtMsgMode());
            ChannelModeCommand.registerMode(modeTypes, new ExceptionMode());
            ChannelModeCommand.registerMode(modeTypes, new TopicLockMode());
            ChannelModeCommand.registerMode(modeTypes, new ModeratedMode());
            ChannelModeCommand.registerMode(modeTypes, new InviteMaskMode());
            ChannelModeCommand.registerMode(modeTypes, new InviteOnlyMode());
            ChannelModeCommand.registerMode(modeTypes, new AnonChannelMode());
        }
    }

    public InCommand parse(String prefix, String identifier, String params) {
        throw new IllegalStateException("Don't call this method!");
    }

    public String render() {
        return "MODE " + this.channelName + this.renderParams();
    }

    public String renderParams() {
        Iterator modesI = this.modes.iterator();
        String modes = "";
        String params = "";
        while (modesI.hasNext()) {
            Mode mode = (Mode)modesI.next();
            if (mode.getSign() != Mode.Sign.NOSIGN) {
                modes = modes + (mode.getSign() == Mode.Sign.POSITIVE ? "+" : "-");
            }
            modes = modes + mode.getChar();
            if (mode.getParam() == null) continue;
            if (params.length() > 0) {
                params = params + " ";
            }
            params = params + mode.getParam();
        }
        return modes + " " + params;
    }

    public String getChannel() {
        return this.channelName;
    }

    public FullNick getSender() {
        return this.sender;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean updateClientState(ClientState state) {
        boolean changed = false;
        Iterator modesI = this.modes.iterator();
        Channel channel = state.getChannel(this.channelName);
        while (modesI.hasNext()) {
            Mode mode = (Mode)modesI.next();
            channel.setMode(mode);
            changed = true;
        }
        return changed;
    }
}

