/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ElementListener;
import com.itextpdf.text.Font;
import com.itextpdf.text.SpecialSymbol;
import com.itextpdf.text.TabSettings;
import com.itextpdf.text.TextElementArray;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.HyphenationEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Phrase
extends ArrayList<Element>
implements TextElementArray {
    private static final long serialVersionUID = 2643594602455068231L;
    protected float leading = Float.NaN;
    protected Font font;
    protected HyphenationEvent hyphenation = null;
    protected TabSettings tabSettings = null;

    public Phrase() {
        this(16.0f);
    }

    public Phrase(Phrase phrase) {
        this.addAll(phrase);
        this.leading = phrase.getLeading();
        this.font = phrase.getFont();
        this.tabSettings = phrase.getTabSettings();
        this.setHyphenation(phrase.getHyphenation());
    }

    public Phrase(float leading) {
        this.leading = leading;
        this.font = new Font();
    }

    public Phrase(Chunk chunk) {
        super.add(chunk);
        this.font = chunk.getFont();
        this.setHyphenation(chunk.getHyphenation());
    }

    public Phrase(float leading, Chunk chunk) {
        this.leading = leading;
        super.add(chunk);
        this.font = chunk.getFont();
        this.setHyphenation(chunk.getHyphenation());
    }

    public Phrase(String string) {
        this(Float.NaN, string, new Font());
    }

    public Phrase(String string, Font font) {
        this(Float.NaN, string, font);
    }

    public Phrase(float leading, String string) {
        this(leading, string, new Font());
    }

    public Phrase(float leading, String string, Font font) {
        this.leading = leading;
        this.font = font;
        if (string != null && string.length() != 0) {
            super.add(new Chunk(string, font));
        }
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            for (Element element : this) {
                listener.add(element);
            }
            return true;
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public int type() {
        return 11;
    }

    @Override
    public List<Chunk> getChunks() {
        ArrayList<Chunk> tmp = new ArrayList<Chunk>();
        for (Element element : this) {
            tmp.addAll(element.getChunks());
        }
        return tmp;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    @Override
    public void add(int index, Element element) {
        if (element == null) {
            return;
        }
        switch (element.type()) {
            case 10: {
                Chunk chunk = (Chunk)element;
                if (!this.font.isStandardFont()) {
                    chunk.setFont(this.font.difference(chunk.getFont()));
                }
                if (this.hyphenation != null && chunk.getHyphenation() == null && !chunk.isEmpty()) {
                    chunk.setHyphenation(this.hyphenation);
                }
                super.add(index, chunk);
                return;
            }
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 23: 
            case 29: 
            case 37: 
            case 50: 
            case 55: 
            case 666: {
                super.add(index, element);
                return;
            }
        }
        throw new ClassCastException(MessageLocalization.getComposedMessage("insertion.of.illegal.element.1", element.getClass().getName()));
    }

    @Override
    public boolean add(String s) {
        if (s == null) {
            return false;
        }
        return super.add(new Chunk(s, this.font));
    }

    @Override
    public boolean add(Element element) {
        if (element == null) {
            return false;
        }
        try {
            switch (element.type()) {
                case 10: {
                    return this.addChunk((Chunk)element);
                }
                case 11: 
                case 12: {
                    Phrase phrase = (Phrase)element;
                    boolean success = true;
                    for (Element element2 : phrase) {
                        Element e = element2;
                        if (e instanceof Chunk) {
                            success &= this.addChunk((Chunk)e);
                            continue;
                        }
                        success &= this.add(e);
                    }
                    return success;
                }
                case 14: 
                case 17: 
                case 23: 
                case 29: 
                case 37: 
                case 50: 
                case 55: 
                case 666: {
                    return super.add(element);
                }
            }
            throw new ClassCastException(String.valueOf(element.type()));
        }
        catch (ClassCastException cce) {
            throw new ClassCastException(MessageLocalization.getComposedMessage("insertion.of.illegal.element.1", cce.getMessage()));
        }
    }

    @Override
    public boolean addAll(Collection<? extends Element> collection) {
        for (Element element : collection) {
            this.add(element);
        }
        return true;
    }

    protected boolean addChunk(Chunk chunk) {
        Font f = chunk.getFont();
        String c = chunk.getContent();
        if (this.font != null && !this.font.isStandardFont()) {
            f = this.font.difference(chunk.getFont());
        }
        if (this.size() > 0 && !chunk.hasAttributes()) {
            try {
                Chunk previous = (Chunk)this.get(this.size() - 1);
                if (!(previous.hasAttributes() || f != null && f.compareTo(previous.getFont()) != 0 || "".equals(previous.getContent().trim()) || "".equals(c.trim()))) {
                    previous.append(c);
                    return true;
                }
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
        }
        Chunk newChunk = new Chunk(c, f);
        newChunk.setAttributes(chunk.getAttributes());
        newChunk.role = chunk.getRole();
        newChunk.accessibleAttributes = chunk.getAccessibleAttributes();
        if (this.hyphenation != null && newChunk.getHyphenation() == null && !newChunk.isEmpty()) {
            newChunk.setHyphenation(this.hyphenation);
        }
        return super.add(newChunk);
    }

    protected void addSpecial(Element object) {
        super.add(object);
    }

    public void setLeading(float leading) {
        this.leading = leading;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public float getLeading() {
        if (Float.isNaN(this.leading) && this.font != null) {
            return this.font.getCalculatedLeading(1.5f);
        }
        return this.leading;
    }

    public float getTotalLeading() {
        return this.getLeading();
    }

    public boolean hasLeading() {
        return !Float.isNaN(this.leading);
    }

    public Font getFont() {
        return this.font;
    }

    public String getContent() {
        StringBuffer buf = new StringBuffer();
        for (Chunk c : this.getChunks()) {
            buf.append(c.toString());
        }
        return buf.toString();
    }

    @Override
    public boolean isEmpty() {
        switch (this.size()) {
            case 0: {
                return true;
            }
            case 1: {
                Element element = (Element)this.get(0);
                return element.type() == 10 && ((Chunk)element).isEmpty();
            }
        }
        return false;
    }

    public HyphenationEvent getHyphenation() {
        return this.hyphenation;
    }

    public void setHyphenation(HyphenationEvent hyphenation) {
        this.hyphenation = hyphenation;
    }

    public TabSettings getTabSettings() {
        return this.tabSettings;
    }

    public void setTabSettings(TabSettings tabSettings) {
        this.tabSettings = tabSettings;
    }

    private Phrase(boolean dummy) {
    }

    public static final Phrase getInstance(String string) {
        return Phrase.getInstance(16, string, new Font());
    }

    public static final Phrase getInstance(int leading, String string) {
        return Phrase.getInstance(leading, string, new Font());
    }

    public static final Phrase getInstance(int leading, String string, Font font) {
        Phrase p = new Phrase(true);
        p.setLeading(leading);
        p.font = font;
        if (font.getFamily() != Font.FontFamily.SYMBOL && font.getFamily() != Font.FontFamily.ZAPFDINGBATS && font.getBaseFont() == null) {
            int index;
            while ((index = SpecialSymbol.index(string)) > -1) {
                if (index > 0) {
                    String firstPart = string.substring(0, index);
                    p.add(new Chunk(firstPart, font));
                    string = string.substring(index);
                }
                Font symbol = new Font(Font.FontFamily.SYMBOL, font.getSize(), font.getStyle(), font.getColor());
                StringBuffer buf = new StringBuffer();
                buf.append(SpecialSymbol.getCorrespondingSymbol(string.charAt(0)));
                string = string.substring(1);
                while (SpecialSymbol.index(string) == 0) {
                    buf.append(SpecialSymbol.getCorrespondingSymbol(string.charAt(0)));
                    string = string.substring(1);
                }
                p.add(new Chunk(buf.toString(), symbol));
            }
        }
        if (string != null && string.length() != 0) {
            p.add(new Chunk(string, font));
        }
        return p;
    }

    public boolean trim() {
        Element lastChunk;
        Element firstChunk;
        while (this.size() > 0 && (firstChunk = (Element)this.get(0)) instanceof Chunk && ((Chunk)firstChunk).isWhitespace()) {
            this.remove(firstChunk);
        }
        while (this.size() > 0 && (lastChunk = (Element)this.get(this.size() - 1)) instanceof Chunk && ((Chunk)lastChunk).isWhitespace()) {
            this.remove(lastChunk);
        }
        return this.size() > 0;
    }
}

