/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.InfBlocks;
import com.jcraft.jzlib.ZStream;

final class Inflate {
    private static final int MAX_WBITS = 15;
    private static final int PRESET_DICT = 32;
    static final int Z_NO_FLUSH = 0;
    static final int Z_PARTIAL_FLUSH = 1;
    static final int Z_SYNC_FLUSH = 2;
    static final int Z_FULL_FLUSH = 3;
    static final int Z_FINISH = 4;
    private static final int Z_DEFLATED = 8;
    private static final int Z_OK = 0;
    private static final int Z_STREAM_END = 1;
    private static final int Z_NEED_DICT = 2;
    private static final int Z_ERRNO = -1;
    private static final int Z_STREAM_ERROR = -2;
    private static final int Z_DATA_ERROR = -3;
    private static final int Z_MEM_ERROR = -4;
    private static final int Z_BUF_ERROR = -5;
    private static final int Z_VERSION_ERROR = -6;
    private static final int METHOD = 0;
    private static final int FLAG = 1;
    private static final int DICT4 = 2;
    private static final int DICT3 = 3;
    private static final int DICT2 = 4;
    private static final int DICT1 = 5;
    private static final int DICT0 = 6;
    private static final int BLOCKS = 7;
    private static final int CHECK4 = 8;
    private static final int CHECK3 = 9;
    private static final int CHECK2 = 10;
    private static final int CHECK1 = 11;
    private static final int DONE = 12;
    private static final int BAD = 13;
    int mode;
    int method;
    long[] was = new long[1];
    long need;
    int marker;
    int nowrap;
    int wbits;
    InfBlocks blocks;
    private static byte[] mark = new byte[]{0, 0, -1, -1};

    Inflate() {
    }

    int inflateReset(ZStream zStream) {
        if (zStream == null || zStream.istate == null) {
            return -2;
        }
        zStream.total_out = 0L;
        zStream.total_in = 0L;
        zStream.msg = null;
        zStream.istate.mode = zStream.istate.nowrap != 0 ? 7 : 0;
        zStream.istate.blocks.reset(zStream, null);
        return 0;
    }

    int inflateEnd(ZStream zStream) {
        if (this.blocks != null) {
            this.blocks.free(zStream);
        }
        this.blocks = null;
        return 0;
    }

    int inflateInit(ZStream zStream, int n) {
        zStream.msg = null;
        this.blocks = null;
        this.nowrap = 0;
        if (n < 0) {
            n = -n;
            this.nowrap = 1;
        }
        if (n < 8 || n > 15) {
            this.inflateEnd(zStream);
            return -2;
        }
        this.wbits = n;
        zStream.istate.blocks = new InfBlocks(zStream, zStream.istate.nowrap != 0 ? null : this, 1 << n);
        this.inflateReset(zStream);
        return 0;
    }

    int inflate(ZStream zStream, int n) {
        if (zStream == null || zStream.istate == null || zStream.next_in == null) {
            return -2;
        }
        n = n == 4 ? -5 : 0;
        int n2 = -5;
        block16: while (true) {
            switch (zStream.istate.mode) {
                case 0: {
                    if (zStream.avail_in == 0) {
                        return n2;
                    }
                    n2 = n;
                    --zStream.avail_in;
                    ++zStream.total_in;
                    if (((zStream.istate.method = zStream.next_in[zStream.next_in_index++]) & 0xF) != 8) {
                        zStream.istate.mode = 13;
                        zStream.msg = "unknown compression method";
                        zStream.istate.marker = 5;
                        continue block16;
                    }
                    if ((zStream.istate.method >> 4) + 8 > zStream.istate.wbits) {
                        zStream.istate.mode = 13;
                        zStream.msg = "invalid window size";
                        zStream.istate.marker = 5;
                        continue block16;
                    }
                    zStream.istate.mode = 1;
                }
                case 1: {
                    int n3;
                    if (zStream.avail_in == 0) {
                        return n2;
                    }
                    n2 = n;
                    --zStream.avail_in;
                    ++zStream.total_in;
                    if (((zStream.istate.method << 8) + (n3 = zStream.next_in[zStream.next_in_index++] & 0xFF)) % 31 != 0) {
                        zStream.istate.mode = 13;
                        zStream.msg = "incorrect header check";
                        zStream.istate.marker = 5;
                        continue block16;
                    }
                    if ((n3 & 0x20) == 0) {
                        zStream.istate.mode = 7;
                        continue block16;
                    }
                    zStream.istate.mode = 2;
                }
                case 2: {
                    if (zStream.avail_in == 0) {
                        return n2;
                    }
                    n2 = n;
                    --zStream.avail_in;
                    ++zStream.total_in;
                    zStream.istate.need = (long)((zStream.next_in[zStream.next_in_index++] & 0xFF) << 24) & 0xFF000000L;
                    zStream.istate.mode = 3;
                }
                case 3: {
                    if (zStream.avail_in == 0) {
                        return n2;
                    }
                    n2 = n;
                    --zStream.avail_in;
                    ++zStream.total_in;
                    zStream.istate.need += (long)((zStream.next_in[zStream.next_in_index++] & 0xFF) << 16) & 0xFF0000L;
                    zStream.istate.mode = 4;
                }
                case 4: {
                    if (zStream.avail_in == 0) {
                        return n2;
                    }
                    n2 = n;
                    --zStream.avail_in;
                    ++zStream.total_in;
                    zStream.istate.need += (long)((zStream.next_in[zStream.next_in_index++] & 0xFF) << 8) & 0xFF00L;
                    zStream.istate.mode = 5;
                }
                case 5: {
                    if (zStream.avail_in == 0) {
                        return n2;
                    }
                    n2 = n;
                    --zStream.avail_in;
                    ++zStream.total_in;
                    zStream.istate.need += (long)zStream.next_in[zStream.next_in_index++] & 0xFFL;
                    zStream.adler = zStream.istate.need;
                    zStream.istate.mode = 6;
                    return 2;
                }
                case 6: {
                    zStream.istate.mode = 13;
                    zStream.msg = "need dictionary";
                    zStream.istate.marker = 0;
                    return -2;
                }
                case 7: {
                    n2 = zStream.istate.blocks.proc(zStream, n2);
                    if (n2 == -3) {
                        zStream.istate.mode = 13;
                        zStream.istate.marker = 0;
                        continue block16;
                    }
                    if (n2 == 0) {
                        n2 = n;
                    }
                    if (n2 != 1) {
                        return n2;
                    }
                    n2 = n;
                    zStream.istate.blocks.reset(zStream, zStream.istate.was);
                    if (zStream.istate.nowrap != 0) {
                        zStream.istate.mode = 12;
                        continue block16;
                    }
                    zStream.istate.mode = 8;
                }
                case 8: {
                    if (zStream.avail_in == 0) {
                        return n2;
                    }
                    n2 = n;
                    --zStream.avail_in;
                    ++zStream.total_in;
                    zStream.istate.need = (long)((zStream.next_in[zStream.next_in_index++] & 0xFF) << 24) & 0xFF000000L;
                    zStream.istate.mode = 9;
                }
                case 9: {
                    if (zStream.avail_in == 0) {
                        return n2;
                    }
                    n2 = n;
                    --zStream.avail_in;
                    ++zStream.total_in;
                    zStream.istate.need += (long)((zStream.next_in[zStream.next_in_index++] & 0xFF) << 16) & 0xFF0000L;
                    zStream.istate.mode = 10;
                }
                case 10: {
                    if (zStream.avail_in == 0) {
                        return n2;
                    }
                    n2 = n;
                    --zStream.avail_in;
                    ++zStream.total_in;
                    zStream.istate.need += (long)((zStream.next_in[zStream.next_in_index++] & 0xFF) << 8) & 0xFF00L;
                    zStream.istate.mode = 11;
                }
                case 11: {
                    if (zStream.avail_in == 0) {
                        return n2;
                    }
                    n2 = n;
                    --zStream.avail_in;
                    ++zStream.total_in;
                    zStream.istate.need += (long)zStream.next_in[zStream.next_in_index++] & 0xFFL;
                    if ((int)zStream.istate.was[0] != (int)zStream.istate.need) {
                        zStream.istate.mode = 13;
                        zStream.msg = "incorrect data check";
                        zStream.istate.marker = 5;
                        continue block16;
                    }
                    zStream.istate.mode = 12;
                }
                case 12: {
                    return 1;
                }
                case 13: {
                    return -3;
                }
            }
            break;
        }
        return -2;
    }

    int inflateSetDictionary(ZStream zStream, byte[] byArray, int n) {
        int n2 = 0;
        int n3 = n;
        if (zStream == null || zStream.istate == null || zStream.istate.mode != 6) {
            return -2;
        }
        if (zStream._adler.adler32(1L, byArray, 0, n) != zStream.adler) {
            return -3;
        }
        zStream.adler = zStream._adler.adler32(0L, null, 0, 0);
        if (n3 >= 1 << zStream.istate.wbits) {
            n3 = (1 << zStream.istate.wbits) - 1;
            n2 = n - n3;
        }
        zStream.istate.blocks.set_dictionary(byArray, n2, n3);
        zStream.istate.mode = 7;
        return 0;
    }

    int inflateSync(ZStream zStream) {
        int n;
        if (zStream == null || zStream.istate == null) {
            return -2;
        }
        if (zStream.istate.mode != 13) {
            zStream.istate.mode = 13;
            zStream.istate.marker = 0;
        }
        if ((n = zStream.avail_in) == 0) {
            return -5;
        }
        int n2 = zStream.next_in_index;
        int n3 = zStream.istate.marker;
        while (n != 0 && n3 < 4) {
            n3 = zStream.next_in[n2] == mark[n3] ? ++n3 : (zStream.next_in[n2] != 0 ? 0 : 4 - n3);
            ++n2;
            --n;
        }
        zStream.total_in += (long)(n2 - zStream.next_in_index);
        zStream.next_in_index = n2;
        zStream.avail_in = n;
        zStream.istate.marker = n3;
        if (n3 != 4) {
            return -3;
        }
        long l = zStream.total_in;
        long l2 = zStream.total_out;
        this.inflateReset(zStream);
        zStream.total_in = l;
        zStream.total_out = l2;
        zStream.istate.mode = 7;
        return 0;
    }

    int inflateSyncPoint(ZStream zStream) {
        if (zStream == null || zStream.istate == null || zStream.istate.blocks == null) {
            return -2;
        }
        return zStream.istate.blocks.sync_point();
    }
}

