/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.runtime.installer.config.AssociationConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.installer.frontend.screens.BaseChecklistScreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class AssociationsScreen
extends BaseChecklistScreen {
    public AssociationsScreen(InstallerWizard installerWizard) {
        super(installerWizard);
    }

    protected void addSingleChecks(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.insets.bottom = 0;
        Iterator iterator = InstallerConfig.getCurrentInstance().getAssociations().iterator();
        while (iterator.hasNext()) {
            AssociationConfig associationConfig = (AssociationConfig)iterator.next();
            SingleAssociationPanel singleAssociationPanel = new SingleAssociationPanel(associationConfig);
            this.checklistPanel.add((Component)singleAssociationPanel, gridBagConstraints);
            this.singleCheckPanels.add(singleAssociationPanel);
            ++gridBagConstraints.gridy;
        }
    }

    protected String getTitle() {
        return this.messages.getString("WizardSelectAssociations");
    }

    protected String getSubTitle() {
        return this.messages.getString("SelectAssociationsDesc");
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(this.messages.getString("SelectAssociationsLabel"), jPanel, gridBagConstraints);
        super.addScreenContent(jPanel, gridBagConstraints);
    }

    protected class SingleAssociationPanel
    extends BaseChecklistScreen.SingleCheckPanel {
        private AssociationConfig associationConfig;
        private JCheckBox chkAssociate;

        public SingleAssociationPanel(AssociationConfig associationConfig) {
            super(AssociationsScreen.this);
            this.associationConfig = associationConfig;
            this.setLayout(new BorderLayout());
            this.chkAssociate = new JCheckBox(associationConfig.getDescription() + " (*." + associationConfig.getExtension() + ")", associationConfig.isSelected());
            this.add((Component)this.chkAssociate, "West");
        }

        public void save() {
            this.associationConfig.setSelected(this.chkAssociate.isSelected());
        }
    }
}

